/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jbpm.jpdl.JpdlException;
import org.jbpm.jpdl.xml.Problem;

public class TemplateReaderException
extends JpdlException {
    private String templateName;
    private int version;
    private static final long serialVersionUID = 2114765932418405999L;

    public TemplateReaderException(List<Problem> problems) {
        super(problems);
    }

    public TemplateReaderException(String message, Throwable cause) {
        super(message, cause);
    }

    public TemplateReaderException(String message) {
        super(message);
    }

    public boolean hasUnresolvedReferences() {
        return !this.getUnresolvedReferences().isEmpty();
    }

    public List<String> getUnresolvedReferences() {
        ArrayList unResolved = Lists.newArrayList();
        for (Object obj : this.problems) {
            Problem problem = (Problem)obj;
            if (problem.getLevel() != 2 || problem.getResource() == null) continue;
            unResolved.add(problem.getResource());
        }
        return unResolved;
    }

    public String toString() {
        String s = ((Object)((Object)this)).getClass().getName();
        String message = System.getProperty("line.separator");
        for (Problem problem : this.problems) {
            if (problem.getLevel() != 2 && problem.getLevel() != 1) continue;
            message = message + problem + System.getProperty("line.separator");
        }
        return s + ": " + message;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public int getTemplateVersion() {
        return this.version;
    }

    public void setTemplateVersion(int version) {
        this.version = version;
    }

    public boolean hasTemplateFullName() {
        return StringUtils.isNotBlank((String)this.getTemplateName()) && this.getTemplateVersion() > 0;
    }

    public String getErroProblemMessage() {
        ArrayList<String> errors = new ArrayList<String>();
        for (Object object : this.problems) {
            Problem problem = (Problem)object;
            if (problem.getLevel() != 2 && problem.getLevel() != 1) continue;
            errors.add(problem.getDescription());
        }
        return errors.isEmpty() ? "" : StringUtils.join(errors, (String)",");
    }
}

