/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tandbergtv.workflow.core.TypeConversionException;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.entity.TemplateContentTypeEnum;
import com.tandbergtv.workflow.core.entity.WorkflowTemplateAttribute;
import com.tandbergtv.workflow.core.entity.WorkflowTemplateDTO;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.internal.IUpdatePolicy;
import com.tandbergtv.workflow.core.util.Watch;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.internal.ISequenceIdGenerator;
import com.tandbergtv.workflow.driver.template.ITemplateCache;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.driver.template.NodeTimeoutSetter;
import com.tandbergtv.workflow.driver.template.SelectorExistsException;
import com.tandbergtv.workflow.driver.template.TemplateCache;
import com.tandbergtv.workflow.driver.template.TemplateObjectConvertor;
import com.tandbergtv.workflow.driver.template.internal.FinderException;
import com.tandbergtv.workflow.driver.template.internal.TemplateDAO;
import com.tandbergtv.workflow.driver.template.internal.TemplateFullNameComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.node.ProcessState;

public class TemplateService
implements ITemplateService {
    public static final String SERVICE_NAME = "Template Service";
    private static final Logger LOGGER = Logger.getLogger(TemplateService.class);
    private TemplateCache templateCache;
    private TemplateDAO templateDao;
    private TemplateObjectConvertor templateConvertor;
    private ISequenceIdGenerator idGenerator;

    public TemplateService(TemplateCache cache, TemplateDAO templateDao, TemplateObjectConvertor templateConvertor, ISequenceIdGenerator idGenerator) {
        this.templateCache = cache;
        this.templateDao = templateDao;
        this.templateConvertor = templateConvertor;
        this.idGenerator = idGenerator;
    }

    public TemplateService(TemplateCache cache, SessionFactory sessionFactory, TemplateObjectConvertor templateConvertor, ISequenceIdGenerator idGenerator) {
        this.templateCache = cache;
        this.templateDao = new TemplateDAO(sessionFactory);
        this.templateConvertor = templateConvertor;
        this.idGenerator = idGenerator;
        this.createCacheUpdatePolicy();
    }

    public void createCacheUpdatePolicy() {
        this.templateCache.setUpdatePolicy((IUpdatePolicy)new IUpdatePolicy<WorkflowTemplate>(){

            public WorkflowTemplate reloadEntity(long key) {
                return TemplateService.this.getTemplateInDbById(key);
            }
        });
    }

    @Override
    public long create(WorkflowTemplate workflowTemplate, String jpdlContent, TemplateContentTypeEnum contentType) {
        if (workflowTemplate.isNew()) {
            workflowTemplate.setId(this.idGenerator.queryId());
            LOGGER.debug((Object)("Workflow Template ID generated: " + workflowTemplate.getId()));
        }
        WorkflowTemplateDTO dto = this.templateConvertor.toTemplateDTO(workflowTemplate, jpdlContent, contentType);
        WorkflowTemplateDTO existed = this.templateDao.getTemplate(workflowTemplate.getName(), workflowTemplate.getVersion());
        if (existed != null) {
            workflowTemplate.setId(existed.getId());
            dto.setId(existed.getId());
            this.templateDao.update(dto);
            LOGGER.info((Object)("Found a existed deactived template, update it to active:" + existed.getFullName() + " ,id:" + dto.getId()));
        } else {
            this.templateDao.create(dto);
        }
        workflowTemplate.setCreateDate(dto.getCreateDate());
        workflowTemplate.setId(dto.getId());
        workflowTemplate.setActive(dto.isActive());
        this.templateCache.cache(workflowTemplate, true);
        return workflowTemplate.getId();
    }

    @Override
    public void delete(String templateName, int version) {
        int countUpdated = this.templateDao.delete(templateName, version);
        if (countUpdated == 0) {
            String msg = "The template does not exist, template: " + templateName + " version: " + version;
            LOGGER.debug((Object)msg);
            return;
        }
        this.remove(templateName);
    }

    @Override
    public void update(WorkflowTemplateAttribute templateAttribute) throws TypeConversionException {
        WorkflowTemplate template = this.getTemplateByFullName(templateAttribute.getTemplateFullName());
        this.templateDao.update(templateAttribute, template.getId());
        template.setStartTaskVariables(templateAttribute.getVariables());
        template.breadthFirstTraversal((NodeVisitor)new NodeTimeoutSetter(templateAttribute.getNodeTimeouts()));
        this.templateCache.cache(template, true);
    }

    @Override
    public void activate(long templateId) {
        this.templateDao.activate(templateId);
        this.updateActiveStatus(templateId, true);
        this.templateCache.cache(this.getTemplateById(templateId), true);
    }

    private void updateActiveStatus(long templateId, boolean isActive) {
        if (this.templateCache.get(templateId) != null) {
            this.templateCache.get(templateId).setActive(isActive);
        }
    }

    @Override
    public void deactivate(long templateId) {
        this.templateDao.deactivate(templateId);
        this.updateActiveStatus(templateId, false);
        this.removeFromCache(templateId);
    }

    @Override
    public void pendingDelete(long templateId) {
        this.templateDao.pendingDelete(templateId);
        this.updateActiveStatus(templateId, false);
        this.templateCache.cache(this.getTemplateById(templateId), true);
    }

    @Override
    public WorkflowTemplate getTemplateByFullName(String templateName) {
        List<WorkflowTemplate> templates = this.findAllTemplates();
        WorkflowTemplate result = null;
        for (WorkflowTemplate template : templates) {
            if (!template.getFullName().equals(templateName)) continue;
            result = template;
            break;
        }
        if (result == null) {
            WorkflowTemplateDTO dto = this.templateDao.getActiveTemplateByFullName(templateName);
            result = this.parseToTemplate(dto);
        }
        return result;
    }

    private WorkflowTemplate parseToTemplate(WorkflowTemplateDTO dto) {
        WorkflowTemplate result = null;
        if (dto != null) {
            try {
                this.addLocalCache(dto);
                result = this.templateCache.get(dto.getId());
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to load Template<" + dto + ">. "), (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public void loadActiveTemplates() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        List<WorkflowTemplateDTO> templateDtos = this.templateDao.loadActiveTemplates();
        LOGGER.info((Object)("Loading templates to cache. Total [" + templateDtos.size() + "] templates."));
        int success = 0;
        Set names = Sets.newConcurrentHashSet();
        for (WorkflowTemplateDTO templateDto : templateDtos) {
            LOGGER.info((Object)("Loading the Template<" + templateDto + ">"));
            try {
                this.logWarningWhenTemplateIsDuplicated(names, templateDto);
                if (!this.addLocalCache(templateDto)) continue;
                ++success;
            }
            catch (IllegalArgumentException e) {
                LOGGER.error((Object)("Failed to load the Template<" + templateDto + ">. " + e.getMessage()));
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to load the Template<" + templateDto + ">. "), (Throwable)e);
            }
        }
        stopwatch.stop();
        LOGGER.info((Object)("Complete loading " + success + " activate templates. Total costs " + Watch.cost((Stopwatch)stopwatch)));
    }

    private void logWarningWhenTemplateIsDuplicated(Set<String> names, WorkflowTemplateDTO templateDto) {
        if (names.contains(templateDto.getName())) {
            LOGGER.warn((Object)("Found duplicated activated Template by Name:" + templateDto.getName()));
        }
        names.add(templateDto.getName());
    }

    private boolean addLocalCache(WorkflowTemplateDTO templateDto) {
        WorkflowTemplate template = this.templateConvertor.toTemplate(templateDto);
        List duplicatedNodeNames = template.findDuplicatedNodeNames();
        if (!duplicatedNodeNames.isEmpty()) {
            String error = "Failed to load the Template< " + template.getFullName() + ">. Find duplicated Nodes [ " + StringUtils.join((Collection)duplicatedNodeNames, (String)",") + "]. Please fix the issue first.";
            LOGGER.error((Object)error);
            return false;
        }
        this.templateCache.cache(template, false);
        return true;
    }

    @Override
    public void addSelectorKey(String selectionKey, String templateName) throws DriverException {
        WorkflowTemplate existingTemplate = this.getTemplateByName(templateName);
        if (existingTemplate == null) {
            throw new FinderException("Failed to find template [" + templateName + "]");
        }
        String templateNameBySK = this.templateDao.getTemplateNameBySelectorKey(selectionKey);
        if (StringUtils.isNotBlank((String)templateNameBySK)) {
            throw new SelectorExistsException("Key " + selectionKey + " is already mapped to template " + templateNameBySK);
        }
        this.templateDao.addSelectorKey(selectionKey, templateName);
    }

    @Override
    public void removeSelectorKey(String selectionKey, String templateName) {
        this.templateDao.removeSelectorKey(selectionKey, templateName);
    }

    @Override
    public WorkflowTemplate getTemplateBySelectorKey(String selectionKey) {
        String templateName = this.templateDao.getTemplateNameBySelectorKey(selectionKey);
        return this.getLatestTemplate(templateName);
    }

    @Override
    public List<WorkflowTemplate> getPreviousVersions(WorkflowTemplate template) {
        LinkedList<WorkflowTemplate> templates = new LinkedList<WorkflowTemplate>();
        int version = template.getVersion();
        for (WorkflowTemplate t : this.findAllTemplates()) {
            if (!t.getName().equals(template.getName()) || t.getVersion() >= version) continue;
            templates.add(t);
        }
        return templates;
    }

    @Override
    public boolean isExistedActiveVersion(String name, int version) {
        return this.templateDao.isExistedActiveVersion(name, version);
    }

    @Override
    public boolean isExistedInLegacyModel(String name, int version) {
        return this.templateDao.isExistedVersionInlegacyModel(name, version);
    }

    @Override
    public WorkflowTemplate rollback(String name, int version) throws FinderException {
        WorkflowTemplate currentActiveTemplate = this.getLatestTemplate(name);
        Long idToActivate = version == 0 ? this.templateDao.getPreviousVersionTemplateId(name, currentActiveTemplate.getVersion()) : this.templateDao.getTemplateIdByVersion(name, version);
        if (idToActivate == 0L) {
            throw new FinderException("Previous version of the template doesn't exist.");
        }
        return this.rollback(idToActivate, currentActiveTemplate);
    }

    private WorkflowTemplate rollback(Long lastVersionId, WorkflowTemplate currentActiveTemplate) {
        this.deactivate(currentActiveTemplate.getId());
        this.activate(lastVersionId);
        return this.getTemplateById(lastVersionId);
    }

    @Override
    public WorkflowTemplate getTemplateById(long templateId) {
        WorkflowTemplate template = this.templateCache.get(templateId);
        if (template == null) {
            template = this.getTemplateInDbById(templateId);
        }
        return template;
    }

    @Override
    public WorkflowTemplate getTemplateInDbById(long templateId) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        WorkflowTemplateDTO templateDto = this.templateDao.getTemplateById(templateId);
        WorkflowTemplate template = null;
        try {
            template = templateDto != null ? this.templateConvertor.toTemplate(templateDto) : null;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Fail to load Template by ID:" + templateId + "."), (Throwable)e);
        }
        LOGGER.debug((Object)("Get template " + template + " from database in " + Watch.cost((Stopwatch)stopwatch)));
        return template;
    }

    @Override
    public WorkflowTemplate getTemplateByName(String templateName) {
        WorkflowTemplate result = this.getLatestTemplate(templateName);
        if (result == null) {
            WorkflowTemplateDTO dto = this.templateDao.getLatestTemplateByName(templateName);
            result = this.parseToTemplate(dto);
        }
        return result;
    }

    @Override
    public List<WorkflowTemplate> findAllTemplates() {
        ArrayList<WorkflowTemplate> templates = new ArrayList<WorkflowTemplate>();
        for (Serializable key : this.templateCache.getKeys()) {
            templates.add(this.templateCache.get((Long)key));
        }
        Collections.sort(templates, new TemplateFullNameComparator());
        return templates;
    }

    @Override
    public List<String> getAllActivatedTemplateNames() {
        List<WorkflowTemplate> templates = this.findAllTemplates();
        ArrayList<String> fullNames = new ArrayList<String>();
        HashSet<String> templateNames = new HashSet<String>();
        for (WorkflowTemplate template : templates) {
            String name = template.getName();
            if (templateNames.contains(name) || !template.isActive()) continue;
            templateNames.add(name);
            fullNames.add(template.getFullName());
        }
        return fullNames;
    }

    @Override
    public List<WorkflowTemplate> getLatestTemplates() {
        List<WorkflowTemplate> templates = this.findAllTemplates();
        return this.excludeNoLivedTemplate(templates);
    }

    private List<WorkflowTemplate> excludeNoLivedTemplate(List<WorkflowTemplate> templates) {
        ArrayList<WorkflowTemplate> list = new ArrayList<WorkflowTemplate>();
        HashSet<String> names = new HashSet<String>();
        for (WorkflowTemplate template : templates) {
            String name = template.getName();
            if (names.contains(name) || !template.isActive()) continue;
            names.add(name);
            list.add(template);
        }
        return list;
    }

    public WorkflowTemplate getLatestTemplate(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        List<WorkflowTemplate> templates = this.findAllTemplates();
        for (WorkflowTemplate template : templates) {
            if (!name.equals(template.getName())) continue;
            LOGGER.debug((Object)("found template with name: " + name));
            return template;
        }
        return null;
    }

    @Override
    public ITemplateCache getCache() {
        return this.templateCache;
    }

    @Override
    public List<String> getSelectorKeysByTemplateName(String templateName) {
        return this.templateDao.getSelectorKeysByTemplateName(templateName);
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
    }

    public void stop() {
    }

    private void remove(String templateName) {
        this.removeFromCache(this.getLatestTemplate(templateName).getId());
    }

    private void removeFromCache(long templateId) {
        this.templateCache.uncache(templateId);
    }

    public TemplateDAO getTemplateDAO() {
        return this.templateDao;
    }

    @Override
    public List<WorkflowTemplate> findReferencedTemplate(WorkflowTemplate template) {
        ArrayList references = Lists.newArrayList();
        for (WorkflowTemplate oldTemplate : this.findAllTemplates()) {
            List subs = oldTemplate.getSubProcessRefers();
            if (subs.isEmpty()) continue;
            for (ProcessState processState : subs) {
                if (!template.getName().equals(processState.getSubProcessDefinition().getName())) continue;
                references.add(oldTemplate);
            }
        }
        return references;
    }

    class NodePath
    implements NodeVisitor {
        StringBuilder path = new StringBuilder();

        NodePath() {
        }

        public void visit(Node node) {
            this.path.append(">> node:" + node.getName() + " superState:" + node.getSuperState());
        }

        public String getPath() {
            return this.path.toString();
        }
    }
}

