/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.internal.IncomingMessageService;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.driver.monitor.IStatistics;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import java.util.concurrent.Callable;

public class AsyncMessagePauseHandler
implements IColleague {
    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.HIGH;
    }

    public void receive(WorkflowEvent event) {
        CustomToken token;
        if (event instanceof WorkflowProcessEvent && ((WorkflowProcessEvent)event).getType() == WorkflowProcessEventType.DEQUEUED && IncomingMessageService.isMarkedPausedAsynMessageNode(token = (CustomToken)((WorkflowProcessEvent)event).getToken())) {
            IncomingMessageService.removeLocalMarked();
            this.paused(token);
        }
    }

    private void paused(final CustomToken token) {
        this.getProcessManagerService().getAsyncMessageNodePauseScheduler().schedule((Callable)new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                token.suspend();
                AsyncMessagePauseHandler.this.counter().paused(token);
                return token;
            }
        });
    }

    protected IProcessManagerService getProcessManagerService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }

    protected IProcessCounter counter() {
        IStatistics stats = this.getProcessManagerService().getStatistics();
        return (IProcessCounter)IProcessCounter.class.cast(stats.getCumulativeStatistics());
    }
}

