/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.google.common.collect.Lists;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.graph.exe.ExecutionContext;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.PartitionEvent;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.event.TaskCreatedEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.event.message.TaskCompleteEvent;
import com.tandbergtv.workflow.driver.event.message.TaskUpdateEvent;
import com.tandbergtv.workflow.driver.internal.CrashRecovery;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCache;
import com.tandbergtv.workflow.driver.search.event.ProcessPersistEvent;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProgressTrackingStrategy;
import com.tandbergtv.workflow.driver.timer.ITimerService;
import com.tandbergtv.workflow.metrics.log.WorkorderMetricsLogger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.Token;

public class EventHandler
implements IColleague {
    private static final Logger LOGGER = Logger.getLogger(EventHandler.class);
    private Scheduler<Void> scheduler = new Scheduler("EventHandler-scheduler", 1, 1);
    private LinkedBlockingQueue<WorkflowProcess> recoverdMessages = new LinkedBlockingQueue(1000);

    public EventHandler() {
        this.scheduler.schedule(() -> this.batchHandleRecoveryMessage(), 1000L, 10000L);
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        Object source = event.getSource();
        if (source == this) {
            return;
        }
        IProcessCounter counter = (IProcessCounter)((Object)this.getProcessManagerService().getStatistics().getCumulativeStatistics());
        if (event instanceof WorkflowProcessEvent) {
            WorkflowProcessEvent e = (WorkflowProcessEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            WorkflowProcess process = token.getProcessInstance();
            LOGGER.debug((Object)(token + ", event " + e.getType()));
            if (e.getType() != WorkflowProcessEventType.CREATED) {
                this.check(process, (WorkflowEvent)e);
            }
            switch (e.getType()) {
                case STARTED: {
                    this.cache(e.getType(), process);
                    WorkorderMetricsLogger.logProcess((CustomToken)token);
                    break;
                }
                case DEQUEUED: 
                case ACQUIRED: 
                case RELEASED: 
                case PRIORITY_CHANGED: {
                    this.cache(e.getType(), process);
                    break;
                }
                case JOINED: {
                    EventHandler.save(process);
                    break;
                }
                case BRANCHED: {
                    counter.branched(token);
                    EventHandler.persist(process);
                    break;
                }
                case DELETED: {
                    EventHandler.persist(process);
                    break;
                }
                case QUEUED: {
                    counter.enqueued(token);
                    this.updateProgress(token, "100");
                    this.cache(e.getType(), process);
                    break;
                }
                case STOPPED: {
                    counter.completed(token);
                    if (token.isRoot()) {
                        EventHandler.persist(process);
                    } else {
                        EventHandler.save(process);
                    }
                    token.end(new ExecutionContext((Token)token));
                    WorkorderMetricsLogger.logProcess((CustomToken)token);
                    break;
                }
                case PAUSING: 
                case CANCELLING: {
                    if (!token.isRoot()) break;
                    EventHandler.save(process);
                    break;
                }
                case PAUSED: {
                    this.deleteTimer(token);
                    EventHandler.save(process);
                    WorkorderMetricsLogger.logProcess((CustomToken)token);
                    break;
                }
                case CANCELLED: {
                    this.deleteTimer(token);
                    EventHandler.persist(process);
                    WorkorderMetricsLogger.logProcess((CustomToken)token);
                    break;
                }
                case FAILED: {
                    counter.failed(token);
                    this.deleteTimer(token);
                    EventHandler.save(process);
                    WorkorderMetricsLogger.logProcess((CustomToken)token);
                    try {
                        if (token.isResumeAfterFail()) {
                            LOGGER.debug((Object)(token + " indicates that it wants to be retried"));
                            CustomToken parent = token.getProcessInstance().getSuperProcessToken();
                            token.setResumeAfterFail(false);
                            if (parent != null) {
                                this.getProcessManagerService().resume(parent);
                                break;
                            }
                            this.getProcessManagerService().resume(token);
                        }
                    }
                    catch (DriverException t) {
                        LOGGER.warn((Object)(process + " failed to resume"), (Throwable)t);
                    }
                    break;
                }
                case CRASHED: 
                case RESUMED: {
                    EventHandler.save(process);
                }
            }
        } else if (event instanceof TaskUpdateEvent) {
            TaskUpdateEvent e = (TaskUpdateEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            this.check(token.getProcessInstance(), event);
            if (token.getStatus() == ProcessStatus.BUSY || token.getStatus() == ProcessStatus.RUNNING) {
                String percent = e.getPercentComplete();
                String name = token.getNode().getName();
                LOGGER.info((Object)(token + " (" + name + ") " + percent + "% complete"));
                this.updateProgress(token, percent);
                this.cache(event.getClass().getSimpleName(), token.getProcessInstance());
            }
        } else if (event instanceof TaskCreatedEvent) {
            TaskCreatedEvent e = (TaskCreatedEvent)event;
            WorkflowProcess process = e.getProcess();
            this.check(process, event);
            EventHandler.persist(process);
        } else if (event instanceof TaskCompleteEvent) {
            TaskCompleteEvent e = (TaskCompleteEvent)event;
            CustomToken token = (CustomToken)e.getToken();
            String name = token.getNode().getName();
            this.check(token.getProcessInstance(), event);
            if (token.getStatus() == ProcessStatus.QUEUED && e.hasFailed()) {
                LOGGER.info((Object)(token + " has failed at (" + name + ")"));
                token.fail(ErrorCategory.NACK, "Received NACK");
            } else {
                LOGGER.info((Object)(token + " (" + name + ") completed"));
            }
        } else if (event instanceof PartitionEvent) {
            this.handlePartitionEvent(event);
        }
    }

    private void handlePartitionEvent(WorkflowEvent event) {
        WorkflowProcessCache processCache = this.getCache();
        if (processCache != event.getSource()) {
            return;
        }
        PartitionEvent e = (PartitionEvent)PartitionEvent.class.cast(event);
        if (!e.isCompleted() || e.isSourceAlive()) {
            return;
        }
        LOGGER.debug((Object)("Partitioning event for " + e.getKeys().size() + " processes: " + e.getEvent()));
        for (Serializable key : e.getKeys()) {
            WorkflowProcess process = (WorkflowProcess)processCache.get(key);
            if (process == null || !process.getCanBeRecovered()) continue;
            LOGGER.debug((Object)("Checking if recovery required for process: " + process.toString()));
            if (ProcessFinder.hasOwner(process)) {
                LOGGER.info((Object)(process.getRootToken() + " is running, no need to recover"));
                continue;
            }
            LOGGER.debug((Object)("Recovery required for process: " + process.toString()));
            this.recoverdMessages.add(process);
        }
    }

    private void batchHandleRecoveryMessage() {
        if (this.recoverdMessages.isEmpty()) {
            return;
        }
        try {
            LOGGER.debug((Object)("Got " + this.recoverdMessages.size() + " processes to recover."));
            ArrayList toHandle = Lists.newArrayList();
            this.recoverdMessages.drainTo(toHandle);
            CrashRecovery recovery = new CrashRecovery();
            recovery.doRecover(toHandle);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to recover process:.", (Throwable)e);
        }
    }

    private void check(WorkflowProcess process, WorkflowEvent event) {
        if (!ProcessFinder.isOwner(process)) {
            LOGGER.warn((Object)(process.getRootToken() + ", received event " + event));
        }
    }

    private IProcessManagerService getProcessManagerService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }

    private static void save(WorkflowProcess process) {
        EventHandler.getPersistenceService().save(process);
    }

    private static void persist(WorkflowProcess process) {
        EventHandler.getPersistenceService().persist(process);
    }

    private static IPersistenceService getPersistenceService() {
        return (IPersistenceService)ServiceRegistry.getDefault().lookup("Process Persistence Service");
    }

    private WorkflowProcessCache getCache() {
        return ServiceLookup.findProcessCacheService();
    }

    private void cache(Object eventType, WorkflowProcess process) {
        String source = this.getClass().getSimpleName() + ".cache(" + eventType + "";
        LOGGER.debug((Object)("cache the process" + process + " from the source:" + source));
        this.getCache().cache(process.getId(), process);
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ProcessPersistEvent(source, process, false));
    }

    private void deleteTimer(CustomToken token) {
        ITimerService service = this.getTimerService();
        if (service != null) {
            service.deleteTimer((Token)token);
        }
    }

    private void updateProgress(CustomToken token, String percent) {
        IProgressTrackingStrategy tracker = (IProgressTrackingStrategy)ServiceRegistry.getDefault().lookup(IProgressTrackingStrategy.class);
        if (tracker == null) {
            return;
        }
        if (percent.equals("100")) {
            tracker.setComplete(token);
        } else {
            tracker.setPercentComplete(token, percent);
        }
    }

    private ITimerService getTimerService() {
        return (ITimerService)ServiceRegistry.getDefault().lookup(ITimerService.class);
    }
}

