/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IMap;
import com.tandbergtv.workflow.core.AutomaticTaskNode;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.NodeGroup;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.message.MessageRejectedEvent;
import com.tandbergtv.workflow.driver.service.IIncomingMessageService;
import com.tandbergtv.workflow.exe.ActionException;
import com.tandbergtv.workflow.message.WorkflowMessage;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.Token;

public class IncomingMessageService
implements IIncomingMessageService,
IColleague {
    private static final Logger LOGGER = Logger.getLogger(IncomingMessageService.class);
    private static final String SERVICE_NAME = "Incoming Message Service";
    private static final String WORKFLOW_INCOMING_MESSAGE_STORE = "wfs-incoming-msg-store";
    private static final String TOKEN_PREFIX = "token-";
    private static final IMap<Serializable, WorkflowMessage> WF_INCOMING_MSG_MAP = IncomingMessageService.getClusterService().getInstance().getMap("wfs-incoming-msg-store");
    private static final ThreadLocal<String> PAUSE_ASYNC_MESSAGE_NODE_ID = new ThreadLocal();

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTING));
        mediator.register((IColleague)this);
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STARTED));
    }

    public void stop() {
        IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPING));
        mediator.unregister((IColleague)this);
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPED));
    }

    @Override
    public void offerMessage(Token token, WorkflowMessage message) {
        CustomToken customToken = (CustomToken)token;
        if (customToken.getStatus() == ProcessStatus.ERROR) {
            LOGGER.debug((Object)("Do not offer task-complete message since token " + customToken + " is error."));
            return;
        }
        long start = System.currentTimeMillis();
        WF_INCOMING_MSG_MAP.put((Object)(TOKEN_PREFIX + token.getId()), (Object)message);
        LOGGER.debug((Object)("add WorkflowMessage to map :" + message));
        if (IncomingMessageService.isNodeGroup(customToken.getCurrentNode())) {
            LOGGER.info((Object)("Enter the async node in NodeGroup :" + customToken + ",offer task-complete signal "));
            String key = token.getProcessInstance().getId() + "_" + token.getId();
            ICountDownLatch latch = IncomingMessageService.getCountDownLatch(key);
            latch.countDown();
        }
        LOGGER.debug((Object)("Time taken to distributedMap().add() - time:" + (System.currentTimeMillis() - start) + " token:" + token.getId() + " uid:" + message.getMessageUID()));
    }

    private static IClusterService getClusterService() {
        return (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
    }

    private void removeFromMessageStore(Token token) {
        WF_INCOMING_MSG_MAP.remove((Object)(TOKEN_PREFIX + token.getId()));
        LOGGER.debug((Object)(token + ", removed message from message store"));
    }

    public String getColleagueName() {
        return this.getClass().getName();
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        if (event instanceof WorkflowProcessEvent) {
            WorkflowProcessEvent e = (WorkflowProcessEvent)event;
            Token token = e.getToken();
            switch (e.getType()) {
                case BRANCHED: 
                case CRASHED: 
                case FAILED: 
                case CANCELLED: 
                case STOPPED: {
                    if (!this.needStoreIncomingMessage(token)) break;
                    this.removeFromMessageStore(token);
                    break;
                }
            }
        } else if (event instanceof MessageRejectedEvent) {
            MessageRejectedEvent e = (MessageRejectedEvent)event;
            boolean removed = WF_INCOMING_MSG_MAP.remove((Object)(TOKEN_PREFIX + e.getToken().getId()), (Object)e.getMessage());
            if (removed) {
                LOGGER.warn((Object)(e.getToken() + ", removed message [" + e.getMessage().getMessageUID() + "] from the message store"));
            }
        }
    }

    private boolean needStoreIncomingMessage(Token token) {
        ProcessDefinition template = token.getProcessInstance().getProcessDefinition();
        return ((WorkflowTemplate)template).hasAsyncMessages();
    }

    @Override
    public WorkflowMessage takeMessage(Token token) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannnot be null!");
        }
        Node tokenNode = token.getNode();
        if (IncomingMessageService.isAsyncInNodeGroup(tokenNode)) {
            LOGGER.info((Object)("Enter the async node in NodeGroup :" + token + ",take task-complete signal "));
            String key = token.getProcessInstance().getId() + "_" + token.getId();
            ICountDownLatch latch = IncomingMessageService.getCountDownLatch(key);
            try {
                WorkflowMessage message = (WorkflowMessage)WF_INCOMING_MSG_MAP.remove((Object)(TOKEN_PREFIX + token.getId()));
                if (message != null) {
                    LOGGER.debug((Object)(token + ", obtain task-complete signal without waiting."));
                    WorkflowMessage workflowMessage = message;
                    return workflowMessage;
                }
                boolean success = latch.await(6L, TimeUnit.HOURS);
                LOGGER.info((Object)(token + ", obtain task-complete signal " + success));
            }
            catch (InterruptedException e) {
                throw new ActionException("Waiting for task-complete timeout", e);
            }
            finally {
                latch.destroy();
            }
        }
        return (WorkflowMessage)WF_INCOMING_MSG_MAP.remove((Object)(TOKEN_PREFIX + token.getId()));
    }

    private static ICountDownLatch getCountDownLatch(String name) {
        IClusterService service = (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
        ICountDownLatch countDownLatch = service.getInstance().getCountDownLatch(name);
        countDownLatch.trySetCount(1);
        return countDownLatch;
    }

    private static boolean isNodeGroup(Node node) {
        return node.toString().contains(NodeGroup.class.getSimpleName());
    }

    private static boolean isAsyncInNodeGroup(Node node) {
        AutomaticTaskNode taskNode;
        boolean result = false;
        if (node instanceof AutomaticTaskNode && (taskNode = (AutomaticTaskNode)AutomaticTaskNode.class.cast(node)).isAsyncInNodeGroup()) {
            result = true;
        }
        return result;
    }

    public static boolean isPasueAsyncMessageNode(CustomToken token) {
        AutomaticTaskNode taskNode;
        boolean result = false;
        if (token.getStatus() != ProcessStatus.PAUSED) {
            return result;
        }
        Node node = token.getCurrentNode();
        if (node instanceof AutomaticTaskNode && (taskNode = (AutomaticTaskNode)AutomaticTaskNode.class.cast(node)).getMessage() != null) {
            result = true;
        }
        return result;
    }

    public static void markedPausedAsynMessageNode(CustomToken token) {
        if (IncomingMessageService.isPasueAsyncMessageNode(token)) {
            String customTokenKey = token.getProcessInstance().getId() + ":" + token.getId();
            PAUSE_ASYNC_MESSAGE_NODE_ID.set(customTokenKey);
        }
    }

    public static void removeLocalMarked() {
        PAUSE_ASYNC_MESSAGE_NODE_ID.remove();
    }

    public static boolean isMarkedPausedAsynMessageNode(CustomToken token) {
        String customTokenKey = token.getProcessInstance().getId() + ":" + token.getId();
        return customTokenKey.equals(PAUSE_ASYNC_MESSAGE_NODE_ID.get());
    }
}

