/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.ICacheService;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;

public class MemoryPersistenceService
implements IPersistenceService {
    private static final String FORMAT_2 = "[Process] {0}, template {1}";
    private static final String FORMAT_1 = "[Process] {0}, template {1}, parent {2}";
    private static final Logger LOGGER = Logger.getLogger(MemoryPersistenceService.class);
    private IClusterService clusterService;
    private ICacheService<WorkflowProcess> cacheService;

    @Override
    public Serializable create(WorkflowProcess process) {
        CustomToken rootToken = process.getRootToken();
        WorkflowTemplate template = process.getProcessDefinition();
        long id = this.getClusterService().generateId(process.getClass().getName());
        process.setId(id);
        if (this.getClusterService().isOwner((Object)process.getId())) {
            this.getCache().add((Serializable)Long.valueOf(process.getId()), (Object)process);
        } else {
            this.updateCache(process);
        }
        CustomToken superProcessToken = process.getSuperProcessToken();
        if (superProcessToken != null) {
            WorkflowProcess parent = superProcessToken.getProcessInstance();
            this.getCache().add((Serializable)Long.valueOf(parent.getId()), (Object)parent);
            LOGGER.info((Object)MessageFormat.format(FORMAT_1, rootToken, template.getFullName(), superProcessToken));
        } else {
            LOGGER.info((Object)MessageFormat.format(FORMAT_2, rootToken, template.getFullName()));
        }
        return Long.valueOf(process.getId());
    }

    @Override
    public WorkflowProcess get(Serializable id) {
        return (WorkflowProcess)this.getCache().get(id);
    }

    @Override
    public List<WorkflowProcess> getAll(List<Serializable> ids) {
        ArrayList<WorkflowProcess> processes = new ArrayList<WorkflowProcess>();
        for (Serializable id : ids) {
            processes.add((WorkflowProcess)this.getCache().get(id));
        }
        return processes;
    }

    @Override
    public CustomToken getToken(Serializable id) {
        return this.get(id).getRootToken();
    }

    @Override
    public void persist(WorkflowProcess process) {
        if (process.hasEnded() || !process.isActive()) {
            this.getCache().remove((Serializable)Long.valueOf(process.getId()));
        } else {
            this.save(process);
        }
    }

    @Override
    public void save(WorkflowProcess process) {
        this.getCache().add((Serializable)Long.valueOf(process.getId()), (Object)process);
    }

    @Override
    public void batchSave(Collection<WorkflowProcess> processes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(CustomToken token) {
        this.save(token.getProcessInstance());
    }

    public String getServiceName() {
        return "Process Persistence";
    }

    public void start() {
    }

    public void stop() {
    }

    private ICacheService<WorkflowProcess> getCache() {
        if (this.cacheService == null) {
            this.cacheService = (ICacheService)ServiceRegistry.getDefault().lookup("Process Cache");
        }
        return this.cacheService;
    }

    private void updateCache(WorkflowProcess process) {
        ConcurrentMap map = ((IDistributedCache)this.getCache()).getMap();
        map.put(process.getId(), process);
    }

    private IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
        }
        return this.clusterService;
    }
}

