/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.driver.internal.DynamicThreadPoolSchedule;
import org.apache.log4j.Logger;

public class MessageScheduler
extends DynamicThreadPoolSchedule<Void> {
    public static final String MESSAGE_THREAD_POOL = "message-thread";
    private static final Logger LOGGER = Logger.getLogger(MessageScheduler.class);
    private static final int MAX_THREADS = 512;
    private static final int MIN_THREADS = 128;

    public MessageScheduler(int core, int size) {
        super(MESSAGE_THREAD_POOL, core, size);
    }

    @Override
    public void setPoolSize(int max, int coreSizeRatioToMax) {
        int currentMaxSize = this.getExecutor().getMaximumPoolSize();
        if (max < 128) {
            LOGGER.debug((Object)"The new thread pools size smaller than the minium value :128skip the shirnk");
            return;
        }
        if (currentMaxSize > max && this.getExecutor().getActiveCount() > max) {
            LOGGER.warn((Object)"The current active thread number great than the new thread pool size, skip the shrink");
            return;
        }
        int safeMax = max > 512 ? 512 : max;
        LOGGER.debug((Object)("Adjust the message thread pool size to :" + safeMax));
        super.setPoolSize(safeMax, coreSizeRatioToMax);
    }
}

