/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.WorkflowProcess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class TaskInstanceFilter {
    public TaskInstance findNewManualTaskInstance(WorkflowProcess process) {
        Assert.notNull((Object)process, (String)"WorkflowProcess cannot be null");
        if (CollectionUtils.isEmpty((Collection)process.getTaskMgmtInstance().getTaskInstances())) {
            return null;
        }
        TaskInstance newTi = null;
        for (Object ti : process.getTaskMgmtInstance().getTaskInstances()) {
            TaskInstance taskInstance = (TaskInstance)ti;
            CustomToken token = (CustomToken)taskInstance.getToken();
            Boolean isNotPersisted = taskInstance.getId() <= 0L;
            if (!this.isManualTaskRunning(process, token, taskInstance) || !isNotPersisted.booleanValue()) continue;
            newTi = taskInstance;
            break;
        }
        return newTi;
    }

    public List<TaskInstance> findManualTaskInstances(CustomToken token) {
        WorkflowProcess process = token.getProcessInstance();
        if (CollectionUtils.isEmpty((Collection)process.getTaskMgmtInstance().getTaskInstances())) {
            return Collections.emptyList();
        }
        ArrayList<TaskInstance> instances = new ArrayList<TaskInstance>();
        for (Object ti : process.getTaskMgmtInstance().getTaskInstances()) {
            boolean isForTargetToken;
            TaskInstance taskInstance = (TaskInstance)ti;
            long tokenIdOnTask = taskInstance.getToken().getId();
            boolean bl = isForTargetToken = tokenIdOnTask == token.getId();
            if (!this.isManualTaskFound(process, taskInstance, tokenIdOnTask) || !isForTargetToken) continue;
            instances.add(taskInstance);
        }
        return instances;
    }

    public boolean isManualTaskRunning(WorkflowProcess process, CustomToken token, TaskInstance taskInstance) {
        return this.isManualTaskFound(process, taskInstance, token.getId()) && TaskInstanceFilter.isCurrentlyManualTask(token);
    }

    public boolean isManualTaskFound(WorkflowProcess process, TaskInstance taskInstance, long tokenId) {
        return process.findToken(tokenId) != null && taskInstance.getTask().getTaskNode() instanceof ManualTaskNode;
    }

    public static boolean isCurrentlyManualTask(CustomToken token) {
        return token.getCurrentNode() instanceof ManualTaskNode;
    }
}

