/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.util.SearchCriteria;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UsageCalculator
implements Runnable {
    private volatile int limit;
    private final Collection<String> keys;
    private final Properties properties;
    private static final Logger LOGGER = Logger.getLogger(UsageCalculator.class);

    public UsageCalculator(int threshold, Collection<String> keys, Properties properties) {
        this.setCreatedLimit(threshold);
        this.keys = keys;
        this.properties = properties;
    }

    public void setCreatedLimit(int threshold) {
        this.limit = threshold == 0 ? Integer.MAX_VALUE : threshold;
    }

    @Override
    public void run() {
        this.calculate();
    }

    public void calculate() {
        Set<Long> ids = this.getTemplates();
        if (ids.isEmpty()) {
            LOGGER.warn((Object)("Skip the usage calculation, cannot find any  template with the specified selector key:" + StringUtils.join(this.keys, (String)",")));
            return;
        }
        int total = this.count(this.buildCriteria(ids, this.getCutoff()));
        boolean flag = total > this.limit;
        this.properties.setProperty("create.limit.exceeded", String.valueOf(flag));
        LOGGER.debug((Object)("Limit: " + this.limit + " actual: " + total + " CREATE_LIMIT_EXCEEDED:" + flag));
    }

    public boolean isLicenseLimitExceeded(CustomToken token) {
        return token.isRoot() && Boolean.parseBoolean(this.properties.getProperty("create.limit.exceeded"));
    }

    private SearchCriteria buildCriteria(Set<Long> ids, Date date) {
        SearchCriteria criteria = new SearchCriteria();
        ListParameter templates = new ListParameter("templateId", SearchType.NUMERIC);
        templates.addValues(ids.toArray());
        criteria.addParameter((SearchParameterBase)templates);
        criteria.addParameter((SearchParameterBase)new ValueParameter("status", SearchType.PROCESSSTATUS, (Object)ProcessStatus.COMPLETED.name()));
        criteria.addParameter((SearchParameterBase)new RangeParameter("end", SearchType.DATE, new SimpleDateFormat("yyyy-MM-dd").format(date)));
        criteria.addParameter((SearchParameterBase)new ValueParameter("all"));
        criteria.setRecordsCount(1);
        return criteria;
    }

    private Set<Long> getTemplates() {
        ITemplateService service = (ITemplateService)ServiceRegistry.getDefault().lookup(ITemplateService.class);
        HashSet<Long> templates = new HashSet<Long>();
        for (String selector : this.keys) {
            try {
                WorkflowTemplate template = service.getTemplateBySelectorKey(selector);
                if (template != null) {
                    templates.add(template.getId());
                    LOGGER.debug((Object)("Found tempalte for creation control : " + template.getFullName()));
                    continue;
                }
                LOGGER.warn((Object)("Cannot find the template for creation control by selector key: " + selector));
            }
            catch (Exception e) {
                LOGGER.error((Object)("error happened when load template : " + e.getMessage()));
            }
        }
        return templates;
    }

    private int count(SearchCriteria criteria) {
        return ((IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class)).expressCount(criteria);
    }

    private Date getCutoff() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

