/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.util.SessionUtils;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.NativeQuery;

public class WorkOrderArchivePersistence {
    private static final String VALUE_ADMINSTATUS = "AdminStatus";
    private static final String VALUE_OPERATIONSTATUS = "OperationalStatus";
    private static final String PARAM_OPERATIONSTATUS = "Opstatus";
    private static final String PARAM_PROCESSIDS = "ProcessIds";
    private static final String SQL_UPDATE = "UPDATE ttv_token SET operationalstatus=:OperationalStatus, adminstatus=:AdminStatus WHERE processId in(:ProcessIds) and operationalstatus=:Opstatus ";
    private static final int SQL_MAX_IN_SIZE = 500;
    private static final Logger LOGGER = Logger.getLogger(WorkOrderArchivePersistence.class);
    private SessionFactory sessionFactory;

    public WorkOrderArchivePersistence(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void bulkUpdateStatusArchived(List<Long> processIDs) throws Exception {
        if (processIDs.isEmpty()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Process Bulk(" + processIDs.size() + " )update DB:" + processIDs.toString()));
        }
        if (processIDs.size() > 500) {
            LOGGER.error((Object)("Too many Work Order to Archive:[" + processIDs.size() + "], Maximum support Work Orders size is" + 500));
            throw new IllegalArgumentException("Too many Work Order to Archive");
        }
        Session session = SessionUtils.getSession((SessionFactory)this.sessionFactory);
        try {
            session.beginTransaction();
            NativeQuery query = session.createSQLQuery(SQL_UPDATE);
            this.setUpdateQueryParameters((SQLQuery)query, processIDs);
            query.executeUpdate();
            session.getTransaction().commit();
        }
        catch (Exception e) {
            session.getTransaction().rollback();
            LOGGER.error((Object)("update sql Exception:" + e));
            throw e;
        }
        finally {
            SessionUtils.closeSession((Session)session);
        }
    }

    private void setUpdateQueryParameters(SQLQuery query, List<Long> processIDs) {
        query.setInteger(VALUE_OPERATIONSTATUS, ProcessStatus.ARCHIVED.ordinal());
        query.setInteger(VALUE_ADMINSTATUS, ProcessStatus.ARCHIVED.ordinal());
        query.setParameterList(PARAM_PROCESSIDS, (Object[])processIDs.toArray(new Long[processIDs.size()]));
        query.setInteger(PARAM_OPERATIONSTATUS, ProcessStatus.ERROR.ordinal());
    }
}

