/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowProcessNote;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.entity.CustomTokenDTO;
import com.tandbergtv.workflow.core.entity.WorkflowProcessDTO;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.internal.CustomTokenConvertor;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.driver.template.TemplateService;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.WorkflowMessageBuilder;
import com.tandbergtv.workflow.message.createid.CreateIDContextFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class WorkflowProcessConvertor {
    private CustomTokenConvertor customTokenConvertor;
    private ITemplateService templateService;

    public WorkflowProcessConvertor(CustomTokenConvertor customTokenConvertor) {
        this.customTokenConvertor = customTokenConvertor;
    }

    public WorkflowProcessDTO toProcessDTO(WorkflowProcess process) {
        if (process == null) {
            return null;
        }
        this.assertProcessId(process);
        return this.toProcessDTO(process, process.getSubProcessInstances());
    }

    private void assertProcessId(WorkflowProcess process) {
        Assert.isTrue((boolean)process.isNotNew(), (String)("No Process Id assigned for current Process->" + this.getProcessInfo(process)));
    }

    private String getProcessInfo(WorkflowProcess process) {
        return "createdId=" + process.getCreateId() + ", status=" + process.getStatus() + ", rootToken= " + process.getSuperProcessToken();
    }

    public WorkflowProcessDTO toProcessDTO(WorkflowProcess process, Collection<WorkflowProcess> subProcessList) {
        Collection childTokens;
        this.assertProcessId(process);
        WorkflowProcessDTO processDto = this.toLightProcessDTO(process);
        if (!CollectionUtils.isEmpty(subProcessList)) {
            ArrayList<WorkflowProcessDTO> subProcessDTOs = new ArrayList<WorkflowProcessDTO>();
            for (WorkflowProcess workflowProcess : subProcessList) {
                subProcessDTOs.add(this.toLightProcessDTO(workflowProcess));
            }
            processDto.setSubProcesses(subProcessDTOs);
        }
        if (!CollectionUtils.isEmpty((Collection)(childTokens = process.getRootToken().getChildTokens()))) {
            for (CustomToken child : childTokens) {
                processDto.addChildrenToken(this.customTokenConvertor.toChildCustomTokenDTO(child));
            }
        }
        return processDto;
    }

    public WorkflowProcessDTO toLightProcessDTO(WorkflowProcess process) {
        this.assertProcessId(process);
        WorkflowProcessDTO processDto = new WorkflowProcessDTO();
        processDto.setId(process.getId());
        CustomTokenDTO rootToken = this.customTokenConvertor.toCustomTokenDTO(process.getRootToken());
        processDto.setRootToken(rootToken);
        processDto.setRootTokenId(rootToken.getTokenId());
        CustomToken superProcessToken = process.getSuperProcessToken();
        if (superProcessToken != null) {
            WorkflowProcess parent = superProcessToken.getProcessInstance();
            processDto.setParentId(parent.getId());
        }
        processDto.setTemplateId(process.getTemplateId());
        processDto.setPriority(process.getPriority());
        processDto.setActive(process.isActive());
        processDto.setProcessNotes(process.getNote());
        processDto.setCreateId(process.getCreateId());
        return processDto;
    }

    public WorkflowProcess toProcessObject(WorkflowProcessDTO processDto) {
        if (processDto == null) {
            return null;
        }
        WorkflowProcess process = this.toLightProcess(processDto);
        CustomToken rootToken = process.getRootToken();
        Collection<CustomToken> childTokens = this.buildChildTokens(processDto, rootToken);
        List subProcessDtos = processDto.getSubProcesses();
        if (!CollectionUtils.isEmpty((Collection)processDto.getSubProcesses())) {
            this.buildSubProcesses(rootToken, childTokens, subProcessDtos);
        }
        return process;
    }

    private void buildSubProcesses(CustomToken rootToken, Collection<CustomToken> childTokens, Collection<WorkflowProcessDTO> subProcessDtos) {
        for (WorkflowProcessDTO subProcessDto : subProcessDtos) {
            WorkflowProcess subProcess = this.toLightProcess(subProcessDto);
            this.customTokenConvertor.convertChildTokens(subProcessDto.getChildrenTokens(), subProcess.getRootToken());
            boolean isSubProcessToken = true;
            CustomTokenDTO subTokenDto = subProcessDto.getRootToken();
            for (CustomToken childToken : childTokens) {
                if (subTokenDto.getParentTokenId() != childToken.getId()) continue;
                childToken.setSubProcessInstance((ProcessInstance)subProcess);
                subProcess.setSuperProcessToken((Token)childToken);
                isSubProcessToken = false;
                break;
            }
            if (!isSubProcessToken) continue;
            subProcess.setSuperProcessToken((Token)rootToken);
            rootToken.setSubProcessInstance((ProcessInstance)subProcess);
        }
    }

    private Collection<CustomToken> buildChildTokens(WorkflowProcessDTO processDto, CustomToken rootToken) {
        List childrenTokenDtos = processDto.getChildrenTokens();
        return this.customTokenConvertor.convertChildTokens(childrenTokenDtos, rootToken);
    }

    private WorkflowProcess toLightProcess(WorkflowProcessDTO processDto) {
        if (processDto == null) {
            return null;
        }
        WorkflowTemplate template = this.getTemplateById(processDto.getTemplateId());
        CustomTokenDTO customTokenDTO = processDto.getRootToken();
        WorkflowProcess process = new WorkflowProcess(template.getProcessDefinition(), processDto.getCreateId(), processDto.getPriority(), customTokenDTO.getOperationalStatus(), customTokenDTO.getAdminStatus());
        process.setId(processDto.getId());
        if (StringUtils.isNotBlank((String)processDto.getProcessNotes())) {
            WorkflowProcessNote processNote = new WorkflowProcessNote();
            processNote.setNotes(processDto.getProcessNotes());
            process.setNote(processNote);
        }
        process.setActive(processDto.isActive());
        process.setUpdateDate(processDto.getUpdateDate());
        CustomToken customToken = process.getRootToken();
        this.customTokenConvertor.refillProcess(process, customTokenDTO);
        this.customTokenConvertor.refillCustomToken(customToken, customTokenDTO);
        return process;
    }

    private WorkflowTemplate getTemplateById(long templateId) {
        return this.getTemplateService().getTemplateById(templateId);
    }

    private ITemplateService getTemplateService() {
        if (this.templateService == null) {
            this.templateService = (ITemplateService)ServiceRegistry.getDefault().lookup(ITemplateService.class);
        }
        return this.templateService;
    }

    public void setTemplateService(TemplateService templateService) {
        this.templateService = templateService;
    }

    public static WorkflowMessage toResumeMessage(WorkflowProcess process) {
        return new WorkflowMessageBuilder().createMessage().resumeCommand().token((Token)process.getRootToken()).priority(process.getPriority().toString()).createId(process.getCreateId()).build();
    }

    public static WorkflowMessage toRetryMessage(WorkflowProcess process) {
        return new WorkflowMessageBuilder().createMessage().retryCommand().token((Token)process.getRootToken()).priority(process.getPriority().toString()).createId(process.getCreateId()).build();
    }

    public static WorkflowMessage toRestartMessage(WorkflowProcess process) {
        String createId = CreateIDContextFactory.createJavaUUIDGenerator().newUUID();
        return new WorkflowMessageBuilder().createMessage().restartCommand().token((Token)process.getRootToken()).priority(process.getPriority().toString()).createId(createId).build();
    }

    public static WorkflowMessage toRecoveryMessage(CustomToken rootToken) {
        WorkflowProcess process = rootToken.getProcessInstance();
        return new WorkflowMessageBuilder().createMessage().recoverCommand().token((Token)rootToken).priority(process.getPriority().toString()).createId(process.getCreateId()).build();
    }

    public static WorkflowMessage toRecoveryMessage(CustomToken rootToken, List<Long> subTokens) {
        WorkflowProcess process = rootToken.getProcessInstance();
        String subTokenIds = null;
        if (subTokens != null && !subTokens.isEmpty()) {
            subTokenIds = StringUtils.join(subTokens, (String)",");
        }
        return new WorkflowMessageBuilder().createMessage().recoverCommand().token((Token)rootToken).priority(process.getPriority().toString()).createId(process.getCreateId()).subTokens(subTokenIds).build();
    }
}

