/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.ericsson.cms.neptune.cluster.task.DistributedLocalCallable;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.driver.internal.callable.TokenCallable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.ProcessState;
import org.springframework.util.CollectionUtils;

public class NotifySuperProcessToken
extends TokenCallable
implements DistributedLocalCallable<CustomToken> {
    private long childPid;
    private CustomToken token;
    private static final long serialVersionUID = 2429984887044821359L;
    private static final Logger LOGGER = Logger.getLogger(NotifySuperProcessToken.class);

    public NotifySuperProcessToken(CustomToken token, long childPid) {
        super(token);
        this.token = token;
        this.childPid = childPid;
    }

    @Override
    public CustomToken call() throws Exception {
        if (!this.isSuperProcessToken(this.token)) {
            LOGGER.warn((Object)(this.token + ", does not have child " + this.childPid));
            return this.token;
        }
        Node node = this.token.getCurrentNode();
        if (!(node instanceof ProcessState)) {
            LOGGER.warn((Object)(this.token + " currently is not on Process State node."));
            return this.token;
        }
        boolean isBypassed = this.checkIfBypassException(this.token);
        if (isBypassed) {
            this.token.signal2();
        } else {
            node.raiseException((Throwable)new JbpmException(ErrorCategory.CHILD_PROCESS_FAILED.name()), (ExecutionContext)new com.tandbergtv.workflow.core.graph.exe.ExecutionContext((Token)this.token));
        }
        return this.token;
    }

    @Override
    protected Callable<CustomToken> innerCallable(CustomToken token) {
        throw new UnsupportedOperationException();
    }

    private boolean isSuperProcessToken(CustomToken token) {
        WorkflowProcess process = token.getSubProcessInstance();
        return process != null;
    }

    private boolean checkIfBypassException(CustomToken token) {
        List exceptionHandlers = token.getProcessInstance().getProcessDefinition().getExceptionHandlers();
        boolean isBypassed = false;
        if (CollectionUtils.isEmpty((Collection)exceptionHandlers)) {
            return isBypassed;
        }
        block0: for (ExceptionHandler exceptionHander : exceptionHandlers) {
            if (CollectionUtils.isEmpty((Collection)exceptionHander.getActions())) {
                LOGGER.error((Object)String.format("A malformation global ExceptionHander has detect. ExceptionClassName: %s, GraphElement: %s, Actions %s", exceptionHander.getExceptionClassName(), exceptionHander.getGraphElement(), exceptionHander.getActions()));
                return isBypassed;
            }
            for (Action action : exceptionHander.getActions()) {
                boolean isIgnored = StringUtils.equalsIgnoreCase((String)action.toString(), (String)"IgnoreException");
                boolean isCaught = StringUtils.equalsIgnoreCase((String)action.toString(), (String)"CatchExceptionHandler");
                if (!isIgnored && !isCaught) continue;
                isBypassed = true;
                continue block0;
            }
        }
        return isBypassed;
    }
}

