/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.InvalidProcessStateException;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.internal.callable.TokenCallable;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCache;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.hibernate.StaleStateException;

public class RecoverToken
extends TokenCallable {
    private static final long serialVersionUID = 1007232026076120855L;
    private static final Logger LOGGER = Logger.getLogger(RecoverToken.class);

    public RecoverToken(CustomToken token) {
        super(token);
        if (!token.isRoot()) {
            throw new InvalidProcessStateException("Token< " + token + "> is not root Token");
        }
    }

    @Override
    public Object getKey() {
        return this.getPid();
    }

    @Override
    protected Callable<CustomToken> innerCallable(final CustomToken token) {
        return new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                try {
                    WorkflowProcess process = token.getProcessInstance();
                    WorkflowProcessCache cache = ServiceLookup.findProcessCacheService();
                    if (process.hasEnded()) {
                        LOGGER.warn((Object)("Token<" + token + "> has ended"));
                        cache.remove(Long.valueOf(process.getId()));
                        return token;
                    }
                    ProcessFinder.updateOwner(process);
                    if (token.getStatus() == ProcessStatus.BRANCHED || token.getStatus() == ProcessStatus.ERROR || token.getSubProcessInstance() != null) {
                        LOGGER.debug((Object)("Token<" + token + "> is in branched/error status or has subprocess. \tSub Process = " + token.getSubProcessInstance()));
                        cache.add((Serializable)Long.valueOf(process.getId()), process);
                    }
                    if (RecoverToken.this.isHalted() && token.getRequestedStatus() != ProcessStatus.CANCELLED && token.getRequestedStatus() != ProcessStatus.PAUSED) {
                        token.suspend();
                        RecoverToken.this.counter().paused(token);
                        return token;
                    }
                    token.recover(RecoverToken.this.resumeOnRecovery());
                }
                catch (StaleStateException e) {
                    RecoverToken.this.handleStaleStateException(token);
                }
                catch (StackOverflowError e) {
                    RecoverToken.this.handleStackOverflowError(token, e);
                }
                catch (Throwable t) {
                    LOGGER.error((Object)token, t);
                }
                return token;
            }
        };
    }

    private boolean isHalted() {
        return Boolean.parseBoolean(ServiceLookup.findProcessManagerService().getProperties().getProperty("isDriverHalted"));
    }

    private void handleStaleStateException(CustomToken token) {
        try {
            token.getProcessInstance().resetId();
            token.recover(this.resumeOnRecovery());
        }
        catch (Throwable t) {
            LOGGER.error((Object)token, t);
        }
    }

    private boolean resumeOnRecovery() {
        return !Boolean.parseBoolean(this.getProcessManagerService().getProperties().getProperty("no.retry.on.recovery"));
    }
}

