/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.ericsson.cms.neptune.cluster.task.DistributedCallable;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.cache.IDistributedCache;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.internal.WorkflowProcessConvertor;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.message.WorkflowMessage;
import com.tandbergtv.workflow.message.producer.ComponentType;
import com.tandbergtv.workflow.message.producer.IMessageProducer;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ResumeCallable
implements DistributedCallable<Void>,
Serializable {
    private static final long serialVersionUID = -853200242386079743L;
    private static final Logger LOGGER = Logger.getLogger(ResumeCallable.class);
    private IClusterService clusterService;

    public Object getKey() {
        return null;
    }

    public Void call() throws Exception {
        LOGGER.info((Object)"Resuming...");
        this.setIsHalted(false);
        if (this.getClusterService().isMaster()) {
            List<WorkflowProcess> processes = this.getSearchService().findAllByStatus(ProcessStatus.PAUSED);
            IMessageProducer service = ServiceLookup.findMessageProducerService();
            for (WorkflowProcess process : processes) {
                WorkflowMessage resumeMessage = WorkflowProcessConvertor.toResumeMessage(process);
                service.publish(ComponentType.WORKFLOW_RESUME_ALL, resumeMessage);
            }
        }
        return null;
    }

    protected IProcessSearchService getSearchService() {
        return (IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class);
    }

    protected IDistributedCache<WorkflowProcess> getCache() {
        return (IDistributedCache)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    protected IProcessManagerService getService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }

    protected void setIsHalted(boolean isHalted) {
        IProcessManagerService service = this.getService();
        Properties properties = service.getProperties();
        properties.setProperty("isDriverHalted", Boolean.toString(isHalted));
        try {
            properties.store((OutputStream)null, null);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Failed to save the halted state", (Throwable)e);
        }
    }

    private IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
        }
        return this.clusterService;
    }
}

