/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.ericsson.cms.neptune.cluster.task.DistributedLocalCallable;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.internal.callable.TokenCallable;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class SignalSuperProcessToken
extends TokenCallable
implements DistributedLocalCallable<CustomToken> {
    private static final Logger LOGGER = Logger.getLogger(SignalSuperProcessToken.class);
    private CustomToken token;
    private WorkflowProcess subProcess;
    private static final long serialVersionUID = 3251238469812711918L;

    public SignalSuperProcessToken(CustomToken token, WorkflowProcess subProcess) {
        super(token);
        this.token = token;
        this.subProcess = subProcess;
    }

    @Override
    public CustomToken call() throws Exception {
        LOGGER.debug((Object)("Get Signaled by subprocess, super process token is " + this.token.toString()));
        if (!this.isSuperProcessToken(this.token)) {
            LOGGER.warn((Object)("Token<" + this.token + "> does not have child : " + this.subProcess));
            return this.token;
        }
        try {
            LOGGER.info((Object)("Completed: notify parent process : " + this.token + " from child " + this.subProcess));
            this.token.signal2();
            LOGGER.info((Object)("Completed: notified parent process : " + this.token + " from child  " + this.subProcess));
        }
        catch (Throwable t) {
            LOGGER.error((Object)("Failed to notify parent process : " + this.token + " from child " + this.subProcess), t);
        }
        return this.token;
    }

    @Override
    protected Callable<CustomToken> innerCallable(CustomToken token) {
        throw new UnsupportedOperationException();
    }

    private boolean isSuperProcessToken(CustomToken token) {
        WorkflowProcess process = token.getSubProcessInstance();
        return process != null;
    }
}

