/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.ericsson.cms.neptune.cluster.service.IClusterService;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.Selector;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.driver.internal.callable.OneShotTokenCallable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class StartToken
extends OneShotTokenCallable {
    private static final long serialVersionUID = -3471049028794105401L;
    private IClusterService clusterService;

    public StartToken(CustomToken token) {
        super(token);
    }

    @Override
    protected Callable<CustomToken> innerCallable(final CustomToken token) {
        return new Callable<CustomToken>(){

            @Override
            public CustomToken call() throws Exception {
                if (token.isRoot()) {
                    WorkflowProcess process = token.getProcessInstance();
                    process.getContextInstance().setVariable("_partition", (Object)StartToken.this.getClusterService().getPartitionId((Object)process.getId()));
                    ProcessFinder.updateOwner(process);
                }
                try {
                    if (StartToken.this.limitExceeded(token)) {
                        token.fail(ErrorCategory.UNHANDLED_EXCEPTION, "License violation: ingest limit exceeded");
                    } else if (StartToken.this.getIsHalted()) {
                        token.suspend();
                        StartToken.this.counter().paused(token);
                    } else {
                        token.start();
                        StartToken.this.counter().started(token);
                    }
                }
                catch (StackOverflowError e) {
                    StartToken.this.handleStackOverflowError(token, e);
                }
                catch (Throwable t) {
                    Logger.getLogger(StartToken.class).error((Object)token, t);
                }
                return token;
            }
        };
    }

    private boolean limitExceeded(CustomToken token) {
        return token.isRoot() && Boolean.parseBoolean(this.getProperty("create.limit.exceeded")) && this.match(token.getProcessInstance().getProcessDefinition());
    }

    private boolean match(WorkflowTemplate template) {
        List<String> selectors = Arrays.asList(this.getProperty("com.tandbergtv.workflow.process.runtime.selectorKeys", "").split(","));
        if (!selectors.isEmpty()) {
            for (Selector selector : template.getSelectorKeys()) {
                if (!selectors.contains(selector.getSelectionKey())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean getIsHalted() {
        return Boolean.parseBoolean(this.getProperty("isDriverHalted"));
    }

    private String getProperty(String property) {
        return ServiceLookup.findProcessManagerService().getProperties().getProperty(property);
    }

    private String getProperty(String property, String defaultValue) {
        return ServiceLookup.findProcessManagerService().getProperties().getProperty(property, defaultValue);
    }

    protected IClusterService getClusterService() {
        if (this.clusterService == null) {
            this.clusterService = (IClusterService)ServiceRegistry.getDefault().lookup(IClusterService.class);
        }
        return this.clusterService;
    }
}

