/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.callable;

import com.ericsson.cms.neptune.cluster.task.DistributedCallable;
import com.google.common.collect.Maps;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.driver.ProcessFinder;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCache;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SuspendCallable
implements DistributedCallable<Void>,
Serializable {
    private static final long serialVersionUID = 882656670124527786L;

    public Object getKey() {
        return null;
    }

    public Void call() throws Exception {
        Logger.getLogger(SuspendCallable.class).info((Object)"Suspending...");
        this.setIsHalted(true);
        HashMap pendingToPause = Maps.newHashMap();
        List<WorkflowProcess> processes = this.getSearchService().findAllByStatus(ProcessStatus.getActiveSet());
        for (WorkflowProcess process2 : processes) {
            pendingToPause.put(process2.getId(), process2);
        }
        WorkflowProcessCache cache = this.getCache();
        IProcessManagerService service = this.getService();
        for (Serializable id2 : cache.getLocalCache().getKeys()) {
            WorkflowProcess process3 = cache.get(id2);
            pendingToPause.put(process3.getId(), process3);
        }
        ISchedulerService<CustomToken> scheduler = this.getScheduler();
        IProcessCounter counter = (IProcessCounter)((Object)service.getStatistics().getCumulativeStatistics());
        pendingToPause.forEach((id, process) -> {
            CustomToken token = process.getRootToken();
            if (process.getCanBePaused() && ProcessFinder.isOwner(process)) {
                scheduler.schedule(() -> {
                    token.suspend();
                    counter.paused(token);
                    return token;
                });
            }
        });
        return null;
    }

    protected ISchedulerService<CustomToken> getScheduler() {
        return this.getService().getScheduler();
    }

    protected WorkflowProcessCache getCache() {
        return (WorkflowProcessCache)ServiceRegistry.getDefault().lookup("Process Cache");
    }

    protected IProcessManagerService getService() {
        return (IProcessManagerService)ServiceRegistry.getDefault().lookup(IProcessManagerService.class);
    }

    protected IProcessSearchService getSearchService() {
        return (IProcessSearchService)ServiceRegistry.getDefault().lookup(IProcessSearchService.class);
    }

    protected void setIsHalted(boolean isHalted) {
        IProcessManagerService service = this.getService();
        Properties properties = service.getProperties();
        properties.setProperty("isDriverHalted", Boolean.toString(isHalted));
        try {
            properties.store((OutputStream)null, null);
        }
        catch (Exception e) {
            Logger.getLogger(SuspendCallable.class).warn((Object)"Failed to save the halted state", (Throwable)e);
        }
    }
}

