/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.internal.monitor.InvalidWorkOrderCleaner;
import com.tandbergtv.workflow.process.ratelimiter.IActiveWorkOrderMonitor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ActiveWorkOrderMonitor
implements IActiveWorkOrderMonitor {
    private static final Logger LOGGER = Logger.getLogger(ActiveWorkOrderMonitor.class);
    private List<WorkflowProcessEventType> stopTypes = Lists.newArrayList((Object[])new WorkflowProcessEventType[]{WorkflowProcessEventType.STOPPED, WorkflowProcessEventType.FAILED, WorkflowProcessEventType.PAUSED, WorkflowProcessEventType.CANCELLED, WorkflowProcessEventType.DELETED});
    private List<WorkflowProcessEventType> ignoreTypes = Lists.newArrayList((Object[])new WorkflowProcessEventType[]{WorkflowProcessEventType.RESUMED, WorkflowProcessEventType.CREATED, WorkflowProcessEventType.CRASHED, WorkflowProcessEventType.RELEASED});
    private List<WorkflowProcessEventType> runningStatus = Lists.newArrayList((Object[])new WorkflowProcessEventType[]{WorkflowProcessEventType.STARTED, WorkflowProcessEventType.ACQUIRED, WorkflowProcessEventType.QUEUED, WorkflowProcessEventType.JOINED});
    private Cache<String, Long> activeWOShortTimeCache;
    private Cache<String, Long> activeWOCache;
    private InvalidWorkOrderCleaner cacheCleaner;
    private Lock lock = new ReentrantLock();
    private ISchedulerService<Void> scheduler;
    private String name;
    private Cache<String, Long> branchedProcessCreateIdCache;

    public ActiveWorkOrderMonitor() {
        this.activeWOShortTimeCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(2L, TimeUnit.MINUTES).build();
        this.activeWOCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(24L, TimeUnit.HOURS).build();
        this.branchedProcessCreateIdCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(24L, TimeUnit.HOURS).build();
        this.cacheCleaner = new InvalidWorkOrderCleaner(this);
    }

    public ActiveWorkOrderMonitor(String name) {
        this();
        this.name = name;
    }

    public void setCacheCleaner(InvalidWorkOrderCleaner cacheCleaner) {
        this.cacheCleaner = cacheCleaner;
        cacheCleaner.setActiveWorkOrderMonitor(this);
    }

    public String getColleagueName() {
        return this.name == null ? this.getClass().getName() : this.name;
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.NORMAL;
    }

    public void receive(WorkflowEvent event) {
        WorkflowProcessEvent e;
        if (event instanceof WorkflowProcessEvent && this.needToHandle(e = (WorkflowProcessEvent)WorkflowProcessEvent.class.cast(event))) {
            this.scheduler.schedule(() -> {
                try {
                    CustomToken token = (CustomToken)e.getToken();
                    LOGGER.debug((Object)("ActiveMonitor: receive a status change event:" + token + " , eventType:" + e.getType()));
                    this.handleEvent(e);
                }
                catch (Exception e1) {
                    LOGGER.error((Object)("Failed to handle event: " + e + ", " + e1.getMessage()));
                    LOGGER.debug((Object)("Failed to handle event: " + e), (Throwable)e1);
                }
                return null;
            });
        }
    }

    private boolean needToHandle(WorkflowProcessEvent event) {
        CustomToken token = (CustomToken)event.getToken();
        if (this.ignoreTypes.contains(event.getType())) {
            return false;
        }
        return !this.isSubProcess(token);
    }

    private boolean isBranchToken(CustomToken token) {
        return token.hasParent() && token.getParent().getStatus() == ProcessStatus.BRANCHED;
    }

    private boolean isSubProcess(CustomToken token) {
        return token.isSubProcess() || StringUtils.isBlank((String)token.getProcessInstance().getCreateId());
    }

    public boolean isInMonitor(String key) {
        this.lock.lock();
        try {
            boolean bl = this.activeWOShortTimeCache.getIfPresent((Object)key) != null || this.activeWOCache.getIfPresent((Object)key) != null;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void handleEvent(WorkflowProcessEvent event) {
        CustomToken token = (CustomToken)event.getToken();
        WorkflowProcess process = token.getProcessInstance();
        String key = StringUtils.trim((String)process.getCreateId());
        String eventType = "Received a Proccess event";
        if (event.getType() == WorkflowProcessEventType.BRANCHED) {
            LOGGER.debug((Object)(eventType + " from " + token + ", key: " + key + ", eventType: " + event.getType()));
            this.branchedProcessCreateIdCache.put((Object)key, (Object)System.currentTimeMillis());
            this.removeActiveWO(key);
            return;
        }
        if (this.isBranchToken(token)) {
            eventType = "Received a Branches event";
            key = Long.toString(token.getId());
            LOGGER.debug((Object)(eventType + " from " + token + ", key:" + key + ", eventType:" + event.getType()));
            if (this.isRunningEvent(event)) {
                LOGGER.debug((Object)("Receive a Branch running event from " + token + ", key:" + key + ", eventType:" + event.getType()));
                this.addActiveWO(key);
            }
        }
        if (event.getType() == WorkflowProcessEventType.JOINED) {
            this.addActiveWO(key);
            this.branchedProcessCreateIdCache.invalidate((Object)process.getCreateId());
        }
        if (this.isRunningEvent(event)) {
            if (this.upgradeCounterToFormalCache(key)) {
                LOGGER.info((Object)(eventType + " for running status, increase the counter -> " + this.info(key, event, process)));
            }
        } else if (this.isEndEvent(event)) {
            this.removeActiveWO(key);
            this.cleanBranchesCounter(event, token, process);
            LOGGER.info((Object)(eventType + " for end status, decrease the counter -> " + this.info(key, event, process)));
        }
    }

    private boolean isRunningEvent(WorkflowProcessEvent event) {
        return this.runningStatus.contains(event.getType());
    }

    private boolean isEndEvent(WorkflowProcessEvent event) {
        return this.stopTypes.contains(event.getType());
    }

    private String info(String key, WorkflowProcessEvent e, WorkflowProcess process) {
        String templateName = process.getProcessDefinition() != null ? process.getProcessDefinition().getFullName() : "";
        return " key:" + key + " template:" + templateName + ", process:" + process + " eventType:" + e.getType() + ", WO Counter: " + this.getActiveWOCount();
    }

    private void cleanBranchesCounter(WorkflowProcessEvent event, CustomToken token, WorkflowProcess process) {
        if (this.isBranchToken(token) && this.isEndEvent(event)) {
            boolean noRunningBranch = true;
            ArrayList tokenIds = Lists.newArrayList();
            for (CustomToken branchToken : process.getChildTokens()) {
                tokenIds.add(Long.toString(branchToken.getId()));
                if (!ProcessStatus.getActiveSet().contains(branchToken.getStatus())) continue;
                noRunningBranch = false;
            }
            if (noRunningBranch && this.isInMonitor(process.getCreateId())) {
                LOGGER.info((Object)("Release a dead branched process : " + process + ",token:" + token + "  type:" + event.getType()));
                this.removeActiveWO(process.getCreateId());
                this.branchedProcessCreateIdCache.invalidate((Object)process.getCreateId());
                for (String key : tokenIds) {
                    this.removeActiveWO(key);
                }
            }
        }
    }

    private boolean upgradeCounterToFormalCache(String createId) {
        if (this.activeWOShortTimeCache.getIfPresent((Object)createId) == null || this.activeWOCache.getIfPresent((Object)createId) != null) {
            return false;
        }
        this.lock.lock();
        try {
            LOGGER.debug((Object)("Upgrade a WO with create id[" + createId + "] to Monitor in formal watch"));
            this.activeWOCache.put((Object)createId, (Object)System.currentTimeMillis());
            this.activeWOShortTimeCache.invalidate((Object)createId);
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    public void addActiveWO(String key) {
        this.lock.lock();
        try {
            LOGGER.debug((Object)("Add a message [" + key + "] to Monitor in short time watch"));
            this.activeWOShortTimeCache.put((Object)key, (Object)System.currentTimeMillis());
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeActiveWO(String key) {
        this.lock.lock();
        try {
            LOGGER.debug((Object)("Remove the  message[" + key + "] from the Monitor."));
            this.activeWOShortTimeCache.invalidate((Object)key);
            this.activeWOCache.invalidate((Object)key);
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getActiveWOCount() {
        return this.getActiveWOSet().size();
    }

    public List<String> getActiveWOSet() {
        this.lock.lock();
        LinkedHashSet ids = Sets.newLinkedHashSet();
        try {
            ConcurrentMap wos = this.activeWOShortTimeCache.asMap();
            if (wos.size() > 0) {
                ids.addAll(Lists.newArrayList(wos.keySet()));
            }
            if ((wos = this.activeWOCache.asMap()).size() > 0) {
                ids.addAll(Lists.newArrayList(wos.keySet()));
            }
        }
        finally {
            this.lock.unlock();
        }
        return ids.isEmpty() ? Lists.newArrayList() : Lists.newArrayList((Iterable)ids);
    }

    public void start() {
        this.cacheCleaner.start();
        this.scheduler = new Scheduler("ActiveWoMonitorEventHandler", 1, 1);
        LOGGER.debug((Object)"Active WorkOrder Monitor service started");
    }

    public void stop() {
        this.activeWOCache.invalidateAll();
        this.activeWOShortTimeCache.invalidateAll();
        this.cacheCleaner.stop();
        this.scheduler.stop();
        LOGGER.debug((Object)"Active WorkOrder Monitor service stopped");
    }

    public Map<String, Long> getActiveWoCache() {
        return this.activeWOCache.asMap();
    }

    public List<String> getActiveWoCreateIdSet() {
        LinkedHashSet ids = Sets.newLinkedHashSet();
        List<String> activeWOSet = this.getActiveWOSet();
        ids.addAll(activeWOSet);
        ids.addAll(this.branchedProcessCreateIdCache.asMap().keySet());
        List<String> collect = ids.stream().filter(e -> !e.matches("\\d+$")).collect(Collectors.toList());
        return collect;
    }
}

