/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.core.Selector;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.event.ColleaguePriority;
import com.tandbergtv.workflow.core.event.IColleague;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEvent;
import com.tandbergtv.workflow.driver.event.WorkflowProcessEventType;
import com.tandbergtv.workflow.driver.internal.ServiceLookup;
import com.tandbergtv.workflow.monitor.core.MetricSample;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ExecutionTimeMonitor
implements IColleague {
    private static final Logger LOGGER = Logger.getLogger(ExecutionTimeMonitor.class);
    private static final String MBEAN_NAME_CONTENT_PROCESSING = "com.tandbergtv.watchpoint:type=ExecutionTime,name=contentprocessing_wo_duration";
    private static final String MBEAN_NAME_DISTRIBUTION = "com.tandbergtv.watchpoint:type=ExecutionTime,name=distribution_wo_duration";
    private static final String MBEAN_NAME_TITLE_LIST_PROCESSING = "com.tandbergtv.watchpoint:type=ExecutionTime,name=titlelistprocessing_wo_duration";
    private static final String MBEAN_NAME_INGEST = "com.tandbergtv.watchpoint:type=ExecutionTime,name=ingest_wo_duration";
    public static final String ANNOTATION_DISTRIBUTION = "@Category(\"Distribution\")";
    public static final String ANNOTATION_CONTENT_PROCESSING = "@Category(\"ContentProcessing\")";
    public static final String ANNOTATION_LOCAL_PROCESSING = "@Category(\"LocalContentProcessing\")";
    public static final String ANNOTATION_TITLE_LIST_PROCESSING = "@Category(\"TitleListProcessing\")";
    private final MetricSample timeForIngestTemplates;
    private final MetricSample timeForContentProcessingTemplates = new MetricSample("com.tandbergtv.watchpoint:type=ExecutionTime,name=contentprocessing_wo_duration");
    private final MetricSample timeForDistributionTemplates = new MetricSample("com.tandbergtv.watchpoint:type=ExecutionTime,name=distribution_wo_duration");
    private final MetricSample timeForTitleListProcessingTemplates = new MetricSample("com.tandbergtv.watchpoint:type=ExecutionTime,name=titlelistprocessing_wo_duration");
    private ISchedulerService<Void> scheduler;
    private volatile Collection<String> ingestionSelectorKeys;

    public ExecutionTimeMonitor() {
        this.timeForIngestTemplates = new MetricSample(MBEAN_NAME_INGEST);
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.timeForContentProcessingTemplates, new ObjectName(this.timeForContentProcessingTemplates.getName()));
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.timeForDistributionTemplates, new ObjectName(this.timeForDistributionTemplates.getName()));
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.timeForTitleListProcessingTemplates, new ObjectName(this.timeForTitleListProcessingTemplates.getName()));
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.timeForIngestTemplates, new ObjectName(this.timeForIngestTemplates.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.scheduler = new Scheduler("ExecutionTimeMonitor-scheduler", 1, 1, true);
        this.scheduler.start();
    }

    public void receive(WorkflowEvent event) {
        if (event instanceof WorkflowProcessEvent) {
            WorkflowProcessEvent e = (WorkflowProcessEvent)WorkflowProcessEvent.class.cast(event);
            if (e.getType() != WorkflowProcessEventType.STOPPED || !e.getToken().isRoot()) {
                return;
            }
            this.scheduler.schedule(() -> {
                try {
                    this.handleEvent(e);
                }
                catch (Exception e1) {
                    LOGGER.error((Object)("Failed to handle the event:" + event + ", type=" + e.getType()), (Throwable)e1);
                }
                return null;
            });
        }
    }

    private void handleEvent(WorkflowProcessEvent e) {
        if (this.ingestionSelectorKeys == null) {
            this.ingestionSelectorKeys = this.getIngestionSelectorKeys();
        }
        WorkflowProcess process = e.getProcess();
        WorkflowTemplate template = process.getProcessDefinition();
        List<String> selectorKeys = this.getTemplateSelectorKeys(template);
        LOGGER.debug((Object)("Found template selector keys ->" + StringUtils.join(selectorKeys, (String)",")));
        long durationSeconds = TimeUnit.MILLISECONDS.toSeconds(process.getEnd().getTime() - process.getStart().getTime());
        if (!Collections.disjoint(this.ingestionSelectorKeys, selectorKeys)) {
            this.timeForIngestTemplates.add(durationSeconds);
        } else {
            Collection category = template.getAnnotations("Category");
            if (category.contains(ANNOTATION_DISTRIBUTION)) {
                this.timeForDistributionTemplates.add(durationSeconds);
            }
            if (category.contains(ANNOTATION_CONTENT_PROCESSING) || category.contains(ANNOTATION_LOCAL_PROCESSING)) {
                this.timeForContentProcessingTemplates.add(durationSeconds);
            }
            if (category.contains(ANNOTATION_TITLE_LIST_PROCESSING)) {
                this.timeForTitleListProcessingTemplates.add(durationSeconds);
            }
        }
    }

    private List<String> getTemplateSelectorKeys(WorkflowTemplate template) {
        return template.getSelectorKeys() == null ? Collections.emptyList() : template.getSelectorKeys().stream().map(Selector::getSelectionKey).collect(Collectors.toList());
    }

    public String getColleagueName() {
        return "execution-timer";
    }

    public ColleaguePriority getColleaguePriority() {
        return ColleaguePriority.LOW;
    }

    private Collection<String> getIngestionSelectorKeys() {
        String keys = ServiceLookup.findProcessManagerService().getProperties().getProperty("com.tandbergtv.workflow.process.runtime.selectorKeys");
        return StringUtils.isNotBlank((String)keys) ? Arrays.asList(keys.split(",")) : Collections.emptySet();
    }
}

