/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.graph.TokenError;
import com.tandbergtv.workflow.driver.internal.monitor.ProcessAlarmMatcher;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmNotification;
import com.tandbergtv.workflow.monitor.core.alarm.AlarmSeverity;
import com.tandbergtv.workflow.monitor.core.alarm.Intent;
import com.tandbergtv.workflow.monitor.core.alarm.IntentAction;
import com.tandbergtv.workflow.monitor.core.alarm.IntentOperation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class ProcessAlarmNotification
implements ProcessAlarmMatcher {
    private static final Logger LOGGER = Logger.getLogger(ProcessAlarmNotification.class);
    public static final String ALARM_RECOVERY_URL = "http://app:7070/workflow/process/";
    public static final String CHILD_PROCESS_ERROR_MSG_PREFIX = "alarms.childProcess.error.prefix";
    public static final String VAR_TITLE_ID = "titleId";
    public static final String VAR_TITLE_BRIEF = "titleBrief";
    public static final String VAR_ANNOTATIONS = "annotations";
    private AtomicInteger counter = new AtomicInteger(0);

    @Override
    public boolean match(CustomToken token, Calendar dateCutoff) {
        return token.getStatus() == ProcessStatus.ERROR && dateCutoff.getTime().before(token.getStart());
    }

    public AlarmNotification buildAlarm(WorkflowProcess process) {
        TokenError error = process.getRootToken().getErrorDetails();
        ArrayList<CustomToken> failedTokens = new ArrayList<CustomToken>();
        if (error == null) {
            Collection childTokens = process.getRootToken().getChildTokens();
            for (CustomToken token : childTokens) {
                if (token.getStatus() != ProcessStatus.ERROR) continue;
                if (token.getErrorDetails() != null) {
                    error = token.getErrorDetails();
                    break;
                }
                failedTokens.add(token);
            }
        }
        try {
            int seq = this.counter.getAndIncrement();
            AlarmNotification notification = this.createAlarmNotification(process, seq, error, failedTokens);
            if (notification != null) {
                URI recoveryUrl = new URI(ALARM_RECOVERY_URL + process.getId());
                if (process.getCanBeRetried()) {
                    notification.addAction(this.createIntent(IntentOperation.Retry, recoveryUrl));
                }
                if (process.getCanBeRestarted() && error.getCategory() != ErrorCategory.TIMEOUT) {
                    notification.addAction(this.createIntent(IntentOperation.Restart, recoveryUrl));
                }
                if (process.getCanBeCancelled()) {
                    notification.addAction(this.createIntent(IntentOperation.Cancel, recoveryUrl));
                }
                return notification;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error occured building alarm for process " + process.getId()), (Throwable)e);
        }
        this.counter.getAndDecrement();
        return null;
    }

    private Intent createIntent(IntentOperation operation, URI recoveryUrl) {
        return Intent.newInstance((IntentOperation)operation, (IntentAction)IntentAction.Command, (URI)recoveryUrl);
    }

    private AlarmNotification createAlarmNotification(WorkflowProcess process, int sequenceNo, TokenError error, List<CustomToken> failedTokens) {
        HashMap<String, Object> processData = new HashMap<String, Object>();
        String titleId = "" + process.getRootToken().getTitleId();
        String titleBrief = (String)process.getContextInstance().getVariable(VAR_TITLE_BRIEF);
        Collection annotations = process.getProcessDefinition().getAnnotations();
        processData.put(VAR_TITLE_ID, titleId);
        processData.put(VAR_TITLE_BRIEF, titleBrief);
        processData.put(VAR_ANNOTATIONS, annotations);
        if (error != null) {
            return new AlarmNotification((Object)process.getId(), (long)sequenceNo, AlarmSeverity.Error, error.getCategory().name(), error.getTime().getTime(), error.getMessageWithKey(), processData);
        }
        if (failedTokens != null && !failedTokens.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append(CHILD_PROCESS_ERROR_MSG_PREFIX);
            Date errorDate = null;
            boolean first = true;
            for (CustomToken token : failedTokens) {
                if (errorDate == null || errorDate.before(token.getStart())) {
                    errorDate = token.getStart();
                }
                errorMessage.append(first ? " " : ", ").append(token.getNode().getName());
                first = false;
            }
            return new AlarmNotification((Object)process.getId(), (long)sequenceNo, AlarmSeverity.Error, ErrorCategory.CHILD_PROCESS_FAILED.toString(), errorDate.getTime(), errorMessage.toString(), processData);
        }
        return null;
    }
}

