/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.driver.monitor.IProcessMonitor;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.service.IProcessSearchService;
import com.tandbergtv.workflow.util.SearchCriteria;

public class ProcessStatistics
implements IProcessMonitor {
    private IProcessSearchService service;

    public ProcessStatistics(IProcessSearchService service) {
        this.service = service;
    }

    @Override
    public int getRunning() {
        return this.count(ProcessStatus.CREATED, ProcessStatus.RUNNING, ProcessStatus.BUSY);
    }

    @Override
    public int getPaused() {
        return this.count(ProcessStatus.PAUSED);
    }

    @Override
    public int getQueued() {
        return this.count(ProcessStatus.QUEUED);
    }

    @Override
    public int getBranched() {
        return this.count(ProcessStatus.BRANCHED);
    }

    @Override
    public int getArchived() {
        return this.count(ProcessStatus.ARCHIVED);
    }

    @Override
    public int getCancelled() {
        return this.count(ProcessStatus.CANCELLED);
    }

    @Override
    public int getCreated() {
        return 0;
    }

    @Override
    public int getFailed() {
        return this.count(ProcessStatus.ERROR);
    }

    @Override
    public int getCompleted() {
        return this.count(ProcessStatus.COMPLETED);
    }

    @Override
    public double getCreateRate() {
        return 0.0;
    }

    @Override
    public int getCreateRatePerMinute() {
        return 0;
    }

    @Override
    public double getMaxCreateRate() {
        return 0.0;
    }

    @Override
    public int getMaxCreateRatePerMinute() {
        return 0;
    }

    @Override
    public int getRestarted() {
        return 0;
    }

    private int count(ProcessStatus ... statuslist) {
        ListParameter parameter = new ListParameter("status", SearchType.PROCESSSTATUS);
        parameter.addValues((Object[])statuslist);
        SearchCriteria criteria = new SearchCriteria();
        criteria.addParameter((SearchParameterBase)parameter);
        criteria.setRecordsCount(1);
        return this.service.expressCount(criteria);
    }

    @Override
    public void setMaxCreateRate(double rate) {
        throw new UnsupportedOperationException();
    }
}

