/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.internal.monitor;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.driver.monitor.IProcessMonitor;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.service.ITokenSearchService;
import com.tandbergtv.workflow.util.SearchCriteria;

public class TokenStatistics
implements IProcessMonitor {
    private ITokenSearchService service;

    public TokenStatistics(ITokenSearchService service) {
        this.service = service;
    }

    @Override
    public int getBranched() {
        return 0;
    }

    @Override
    public int getArchived() {
        return this.count(ProcessStatus.ARCHIVED);
    }

    @Override
    public int getCancelled() {
        return this.count(ProcessStatus.CANCELLED);
    }

    @Override
    public int getCompleted() {
        return this.count(ProcessStatus.COMPLETED);
    }

    @Override
    public double getCreateRate() {
        return 0.0;
    }

    @Override
    public int getCreateRatePerMinute() {
        return 0;
    }

    @Override
    public int getCreated() {
        return this.count(ProcessStatus.CREATED);
    }

    @Override
    public int getFailed() {
        return this.count(ProcessStatus.ERROR);
    }

    @Override
    public double getMaxCreateRate() {
        return 0.0;
    }

    @Override
    public int getMaxCreateRatePerMinute() {
        return 0;
    }

    @Override
    public void setMaxCreateRate(double rate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPaused() {
        return this.count(ProcessStatus.PAUSED);
    }

    @Override
    public int getQueued() {
        return this.count(ProcessStatus.QUEUED);
    }

    @Override
    public int getRestarted() {
        return 0;
    }

    @Override
    public int getRunning() {
        return this.count(ProcessStatus.ACTIVE);
    }

    protected int count(ProcessStatus status) {
        SearchCriteria criteria = new SearchCriteria();
        criteria.addParameter((SearchParameterBase)new ValueParameter("child", SearchType.STRING, (Object)Boolean.TRUE));
        ListParameter parameter = new ListParameter("status", SearchType.PROCESSSTATUS);
        parameter.addValue((Object)ProcessStatus.BRANCHED);
        criteria.addParameter((SearchParameterBase)parameter);
        parameter = new ListParameter("tokenstatus", SearchType.PROCESSSTATUS);
        if (status == ProcessStatus.ACTIVE) {
            parameter.addValues(new Object[]{ProcessStatus.CREATED, ProcessStatus.RUNNING, ProcessStatus.BUSY});
        } else {
            parameter.addValue((Object)status);
        }
        criteria.addParameter((SearchParameterBase)parameter);
        return this.service.count(criteria);
    }
}

