/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.process.archived;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tandbergtv.workflow.driver.internal.WorkOrderArchivePersistence;
import com.tandbergtv.workflow.driver.process.WorkflowProcessCache;
import com.tandbergtv.workflow.driver.process.archived.ChildWorkOrders;
import com.tandbergtv.workflow.driver.process.archived.IWorkOrderArchiveService;
import com.tandbergtv.workflow.driver.search.elasticsearch.IWFSElasticSearchPersistanceHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class WorkOrderArchiveService
implements IWorkOrderArchiveService {
    private static final Logger LOGGER = Logger.getLogger(WorkOrderArchiveService.class);
    public static final String SERVICE_NAME = "Work Order Archive Service";
    private WorkOrderArchivePersistence workOrderArchivePersistence;
    private WorkflowProcessCache processCache;
    private IWFSElasticSearchPersistanceHelper elasticSearchHelper;

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
    }

    public void stop() {
    }

    public void setWorkOrderArchivePersistence(WorkOrderArchivePersistence workOrderArchivePersistence) {
        this.workOrderArchivePersistence = workOrderArchivePersistence;
    }

    public void setProcessCache(WorkflowProcessCache processCache) {
        this.processCache = processCache;
    }

    public void setElasticSearchHelper(IWFSElasticSearchPersistanceHelper elasticSearchHelper) {
        this.elasticSearchHelper = elasticSearchHelper;
    }

    @Override
    public List<Long> archiveWorkOrders(List<Long> parentWoIds) {
        if (parentWoIds.isEmpty()) {
            LOGGER.warn((Object)"Work Order IDs isEmpty exit");
            return Collections.emptyList();
        }
        try {
            ChildWorkOrders childWorkOrders = new ChildWorkOrders();
            childWorkOrders.setChildWoIdMap(this.elasticSearchHelper.searchChildWoByParent(parentWoIds));
            List<Long> archiveWoIds = this.getArchiveWorkOrderIds(parentWoIds, childWorkOrders);
            List<Long> retryList = this.startArchive(archiveWoIds);
            if (retryList.isEmpty()) {
                return Collections.emptyList();
            }
            if (retryList.size() == archiveWoIds.size()) {
                this.logArchiveFailedWoIDs(parentWoIds);
                return parentWoIds;
            }
            return this.getParentWoByFaildWo(childWorkOrders, retryList);
        }
        catch (Exception e) {
            LOGGER.error((Object)("archive exception:" + e));
            this.logArchiveFailedWoIDs(parentWoIds);
            return parentWoIds;
        }
    }

    private List<Long> startArchive(List<Long> archiveWoIds) throws Exception {
        if (archiveWoIds.isEmpty()) {
            return archiveWoIds;
        }
        this.workOrderArchivePersistence.bulkUpdateStatusArchived(archiveWoIds);
        this.processCache.removeWorkflowProcesses(archiveWoIds);
        return this.elasticSearchHelper.bulkUpdateStatusArchived(archiveWoIds);
    }

    private List<Long> getArchiveWorkOrderIds(List<Long> parentWoIds, ChildWorkOrders childWorkOrders) {
        ArrayList workOrderIdsList = Lists.newArrayList(parentWoIds);
        if (childWorkOrders.isNoEmpty()) {
            workOrderIdsList.addAll(childWorkOrders.getChildSet());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("archive Work Order IDs:" + ((Object)workOrderIdsList).toString()));
        }
        return workOrderIdsList;
    }

    private List<Long> getParentWoByFaildWo(ChildWorkOrders childWorkOrders, List<Long> failedWoIds) {
        HashSet parentWoIdSet = Sets.newHashSet();
        for (Long id : failedWoIds) {
            if (childWorkOrders.isChildWorkOrder(id)) {
                parentWoIdSet.add(childWorkOrders.getParentId(id));
                continue;
            }
            parentWoIdSet.add(id);
        }
        ArrayList pararentWoIds = Lists.newArrayList((Iterable)parentWoIdSet);
        this.logArchiveFailedWoIDs(pararentWoIds);
        return pararentWoIds;
    }

    private void logArchiveFailedWoIDs(List<Long> woIds) {
        if (!woIds.isEmpty()) {
            LOGGER.warn((Object)("archived fail work orders id(" + woIds.size() + "):" + woIds.toString()));
        }
    }
}

