/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch;

import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsParameters;
import com.tandbergtv.workflow.message.util.ClassUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;

public class WFSElasticSearchFilterBuilder {
    public static QueryBuilder getFilterBuilder(SearchParameterBase searchParameter) {
        if (searchParameter instanceof ListParameter) {
            return WFSElasticSearchFilterBuilder.getListParameterFilter(searchParameter);
        }
        if (searchParameter instanceof RangeParameter) {
            return WFSElasticSearchFilterBuilder.getRangeParameterFilter(searchParameter);
        }
        if (searchParameter instanceof ValueParameter) {
            return WFSElasticSearchFilterBuilder.getValueParameterFilter(searchParameter);
        }
        return null;
    }

    private static Date getDateFormat(String inputDate) {
        if (StringUtils.isBlank((String)inputDate)) {
            return null;
        }
        Date outputDate = null;
        try {
            outputDate = new SimpleDateFormat("yyyy-MM-dd").parse(inputDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return outputDate;
    }

    private static Date getDateTimeFormat(String inputDate) {
        if (StringUtils.isBlank((String)inputDate)) {
            return null;
        }
        Date outputDate = null;
        try {
            outputDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(inputDate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return outputDate;
    }

    private static QueryBuilder getListParameterFilter(SearchParameterBase searchParameter) {
        String esPropertyName = WfsEsParameters.mapUIColumnToESProperty(searchParameter.getFieldName());
        ListParameter listParameter = (ListParameter)ListParameter.class.cast(searchParameter);
        List<Object> values = WFSElasticSearchFilterBuilder.extractListValues(listParameter);
        if (((ListParameter)searchParameter).getOperator() == SearchOperator.EQUAL) {
            return QueryBuilders.termsQuery((String)esPropertyName, values);
        }
        if (((ListParameter)searchParameter).getOperator() == SearchOperator.IN) {
            if (values == null || values.size() == 0) {
                return QueryBuilders.existsQuery((String)esPropertyName);
            }
            if (values.contains(ProcessStatus.ACTIVE.toString())) {
                values.add(ProcessStatus.CREATED.toString());
                values.add(ProcessStatus.BUSY.toString());
                values.add(ProcessStatus.RUNNING.toString());
            }
            return new BoolQueryBuilder().should((QueryBuilder)QueryBuilders.termsQuery((String)esPropertyName, values));
        }
        return null;
    }

    static List<Object> extractListValues(ListParameter listParameter) {
        String firstObject;
        List values = listParameter.getValues();
        String string = firstObject = values == null || values.isEmpty() ? "" : listParameter.getValues().get(0);
        if (firstObject == null || "".equals(firstObject) || ClassUtils.isPrimitiveType((Object)firstObject)) {
            return values;
        }
        return values.stream().filter(o -> o != null).map(Object::toString).collect(Collectors.toList());
    }

    private static QueryBuilder getRangeParameterFilter(SearchParameterBase searchParameter) {
        String to;
        String esPropertyName = WfsEsParameters.mapUIColumnToESProperty(searchParameter.getFieldName());
        RangeQueryBuilder rangeFilterBuilder = QueryBuilders.rangeQuery((String)esPropertyName).includeLower(true).includeUpper(true);
        String from = ((RangeParameter)RangeParameter.class.cast(searchParameter)).getFrom();
        if (StringUtils.isNotBlank((String)from)) {
            String fromDate = WFSElasticSearchFilterBuilder.getFullLongFormatedDate(from, false);
            rangeFilterBuilder.from((Object)fromDate);
        }
        if (StringUtils.isNotBlank((String)(to = ((RangeParameter)RangeParameter.class.cast(searchParameter)).getTo()))) {
            String toDate = WFSElasticSearchFilterBuilder.getFullLongFormatedDate(to, true);
            rangeFilterBuilder.to((Object)toDate);
        }
        return rangeFilterBuilder;
    }

    private static String getFullLongFormatedDate(String dateString, boolean plusOneDayRequired) {
        if (StringUtils.isBlank((String)dateString)) {
            return null;
        }
        if (dateString.length() > "yyyy-MM-dd".length()) {
            Date date = WFSElasticSearchFilterBuilder.getDateTimeFormat(dateString);
            return WFSElasticSearchFilterBuilder.getFullLongFormatedDate(date);
        }
        Date date = WFSElasticSearchFilterBuilder.getDateFormat(dateString);
        if (plusOneDayRequired) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(5, 1);
            date = calendar.getTime();
        }
        return WFSElasticSearchFilterBuilder.getFullLongFormatedDate(date);
    }

    private static String getFullLongFormatedDate(Date date) {
        return date == null ? null : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(date);
    }

    private static QueryBuilder getValueParameterFilter(SearchParameterBase searchParameter) {
        String esPropertyName = WfsEsParameters.mapUIColumnToESProperty(searchParameter.getFieldName());
        Object value = ((ValueParameter)searchParameter).getValue();
        if (value != null && WFSElasticSearchFilterBuilder.isProcessStatus(value.toString())) {
            value = value.toString().toUpperCase();
        }
        if (((ValueParameter)searchParameter).getOperator() == SearchOperator.EQUAL) {
            if (value == null) {
                return new BoolQueryBuilder().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)esPropertyName));
            }
            if (ProcessStatus.ACTIVE.toString().equals(value)) {
                return new BoolQueryBuilder().should((QueryBuilder)QueryBuilders.termsQuery((String)esPropertyName, (String[])new String[]{ProcessStatus.CREATED.toString(), ProcessStatus.RUNNING.toString(), ProcessStatus.BUSY.toString()}));
            }
            return QueryBuilders.termQuery((String)esPropertyName, (Object)value);
        }
        if (((ValueParameter)searchParameter).getOperator() == SearchOperator.IN) {
            return new BoolQueryBuilder().should((QueryBuilder)QueryBuilders.termsQuery((String)esPropertyName, (Object[])new Object[]{value}));
        }
        if (((ValueParameter)searchParameter).getOperator() == SearchOperator.LIKE) {
            return QueryBuilders.wildcardQuery((String)esPropertyName, (String)("*" + value + "*"));
        }
        return null;
    }

    private static boolean isProcessStatus(String value) {
        for (ProcessStatus status : ProcessStatus.values()) {
            if (!status.name().equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }
}

