/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch;

import com.google.common.collect.Maps;
import com.tandbergtv.workflow.core.ProcessStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;

public class WFSEsArchivedRequestBuilder {
    private static final String STATUS_ARCHIVE = "ARCHIVED";
    private static final String SCRIPT_LANG = "painless";
    private static final String FIELD_ADMINSTATUS = "adminStatus";
    private static final String FIELD_STATUS = "status";

    private WFSEsArchivedRequestBuilder() {
    }

    private static Script getUpdateStatusScript() {
        HashMap params = Maps.newHashMap();
        params.put(FIELD_ADMINSTATUS, STATUS_ARCHIVE);
        params.put(FIELD_STATUS, STATUS_ARCHIVE);
        String code = "if( ctx._source.status == \"ERROR\") { ctx._source.status = params.status; ctx._source.adminStatus = params.adminStatus}";
        return new Script(ScriptType.INLINE, SCRIPT_LANG, code, (Map)params);
    }

    public static ActionFuture<BulkResponse> bulkArchiveRequest(List<Long> archivedList, BulkRequestBuilder bulkBuilder) {
        Script script = WFSEsArchivedRequestBuilder.getUpdateStatusScript();
        for (Long id : archivedList) {
            UpdateRequest updateRequest = new UpdateRequest("wfs", "_doc", id.toString());
            updateRequest.script(script);
            bulkBuilder.add(updateRequest);
        }
        return bulkBuilder.execute();
    }

    public static void searchStatusByIdBuilder(List<Long> woIds, SearchRequestBuilder builder) {
        builder.setFetchSource("id", null);
        builder.setFetchSource(FIELD_STATUS, null);
        BoolQueryBuilder filterBuilder = new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.termsQuery((String)"id", woIds));
        builder.setPostFilter((QueryBuilder)filterBuilder);
    }

    public static void searchChildWoIdsBuilder(List<Long> woIds, SearchRequestBuilder builder) {
        builder.setFetchSource("id", null);
        builder.setFetchSource("parentProcessId", null);
        BoolQueryBuilder filterBuilder = new BoolQueryBuilder().must((QueryBuilder)QueryBuilders.termsQuery((String)"parentProcessId", woIds)).must((QueryBuilder)QueryBuilders.termQuery((String)FIELD_STATUS, (String)ProcessStatus.ERROR.toString()));
        builder.setPostFilter((QueryBuilder)filterBuilder);
    }
}

