/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessPriority;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WFSearchResult;
import com.tandbergtv.workflow.core.WFToken;
import com.tandbergtv.workflow.core.WFVariable;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.util.Configuration;
import com.tandbergtv.workflow.driver.internal.ConfFolder;
import com.tandbergtv.workflow.driver.search.elasticsearch.WfsEsParameters;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.SearchHit;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.context.exe.variableinstance.DateInstance;
import org.jbpm.context.exe.variableinstance.StringInstance;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.exe.Token;
import org.springframework.util.Assert;

public class WfsEsProcessHelper {
    private static final Logger LOGGER = Logger.getLogger(WfsEsProcessHelper.class);
    private static final int INVALID_ID = -1;
    private static final String LICENSING_WINDOW_START = "licensingWindowStart";
    private static final String LICENSING_WINDOW_END = "licensingWindowEnd";
    private static final String LICENSE_START_LEGACY_KEY = "license_start";
    private static final String LICENSE_END_LEGACY_KEY = "license_end";
    private static final String LAST_ALLOCATED_RESOURCE_VARIABLE = "_last_allocated_resource";
    private static final String HOST_ADDRESS_VARIABLE = "_host_address";
    private static WfsEsProcessHelper instance = new WfsEsProcessHelper();
    private static final String DEFAULT_MAPPING_FILE = "com/tandbergtv/workflow/driver/search/elasticsearch/wfs_index.json";
    private static final String CUSTOM_MAPPING_FILE = "custom_wfs_mappings.json";
    private int connectionTimeout = 3000;
    private List<String> defaultMappingFields = new ArrayList<String>();
    private List<String> customMappingFields = new ArrayList<String>();

    private WfsEsProcessHelper() {
        this.initializeMappingFields();
    }

    public static WfsEsProcessHelper getInstance() {
        return instance;
    }

    public XContentBuilder createProcess(WorkflowProcess process) throws IOException {
        if (process == null || process.getId() < 1L || process.getRootToken() == null) {
            throw new IllegalArgumentException("Process appears to be invalid");
        }
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.prettyPrint();
        builder.startObject();
        this.addSearchFields(builder, process);
        builder.endObject();
        return builder;
    }

    public XContentBuilder createGUIParitalUpdateBuilder(WorkflowProcess process) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        this.addSearchableField(builder, "priority", process.getPriority());
        this.addSearchableField(builder, "note", process.getFormatedNotes());
        builder.endObject();
        return builder;
    }

    public XContentBuilder createBuilder(WFSearchResult wfsResult) throws IOException {
        if (wfsResult == null || wfsResult.getProcessId() < 1L || wfsResult.getToken().getTokenId() < 1L) {
            throw new IllegalArgumentException("WFSearchResult appears to be invalid");
        }
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.prettyPrint();
        builder.startObject();
        this.addSearchFields(builder, wfsResult);
        builder.endObject();
        return builder;
    }

    public boolean trySaving(String id, XContentBuilder source, TransportClient client) {
        if (client == null) {
            LOGGER.error((Object)("Could not index process " + id + ". ElasticSearch client is not initialized."));
            return false;
        }
        try {
            IndexRequestBuilder bld = client.prepareIndex("wfs", "_doc", id);
            bld.setSource(source);
            bld.execute().actionGet((long)this.connectionTimeout);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Could not index process " + id), (Throwable)e);
            return false;
        }
    }

    public boolean savingNoWait(String id, XContentBuilder source, TransportClient client) {
        if (client == null) {
            LOGGER.error((Object)("Could not index process " + id + ". ElasticSearch client is not initialized."));
            return false;
        }
        try {
            IndexRequestBuilder bld = client.prepareIndex("wfs", "_doc", id);
            bld.setSource(source);
            bld.execute();
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Could not index process " + id), (Throwable)e);
            return false;
        }
    }

    public boolean tryDeleting(String id, TransportClient client) {
        if (client == null) {
            LOGGER.error((Object)("Could not index process " + id + ". ElasticSearch client is not initialized."));
            return false;
        }
        try {
            DeleteRequestBuilder bld = client.prepareDelete("wfs", "_doc", id);
            bld.execute().actionGet(3000L);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Could not delete process " + id), (Throwable)e);
            return false;
        }
    }

    private void addSearchFields(XContentBuilder bldr, WFSearchResult wfsResult) {
        long titleId;
        Map variables = wfsResult.getVariables();
        this.addSearchableField(bldr, "id", wfsResult.getProcessId());
        if (variables.get("templateId") != null) {
            this.addSearchableField(bldr, "templateId", Long.valueOf(((WFVariable)variables.get("templateId")).getValue()));
        }
        this.addSearchableField(bldr, "templateName", wfsResult.getProcessDefinitionName());
        this.addSearchableField(bldr, "adminStatus", ProcessStatus.values()[wfsResult.getToken().getAdministrativeStatus()]);
        this.addSearchableField(bldr, "status", ProcessStatus.values()[wfsResult.getToken().getOperationalStatus()]);
        this.addSearchableField(bldr, "priority", ProcessPriority.values()[wfsResult.getPriority()]);
        this.addSearchableField(bldr, "createId", wfsResult.getCreateId().toString());
        long providerId = this.getLongField(variables, "providerId");
        if (this.isValidId(providerId)) {
            this.addSearchableField(bldr, "providerId", providerId);
        }
        if (this.isValidId(titleId = this.getLongField(variables, "titleId"))) {
            this.addSearchableField(bldr, "titleId", titleId);
        }
        this.addSearchableField(bldr, "isActive", Boolean.valueOf(wfsResult.getIsActive()));
        this.addSearchableField(bldr, "currentTask", wfsResult.getToken().getNodeName());
        this.addSearchableField(bldr, "startTime", wfsResult.getToken().getStartTime());
        this.addSearchableField(bldr, "endTime", wfsResult.getToken().getEndTime());
        this.addSearchableField(bldr, "superProcessTokenId", wfsResult.getSuperProcessTokenId());
        this.addSearchableField(bldr, "hasChildren", wfsResult.getToken().getAllChildren().size() > 0);
        this.addSearchableField(bldr, "hasFailedBranch", wfsResult.isHasFailedBranch());
        this.addSearchableField(bldr, "rootTokenId", wfsResult.getToken().getTokenId());
        if (wfsResult.getToken().getErrorTime() != null) {
            this.addSearchableField(bldr, "errorTime", wfsResult.getToken().getErrorTime());
        }
        if (wfsResult.getToken().getErrorComment() != null && !wfsResult.getToken().getErrorComment().isEmpty()) {
            this.addSearchableField(bldr, "errorComment", wfsResult.getToken().getErrorComment());
        }
        if (wfsResult.getToken().getErrorType() > 0) {
            this.addSearchableField(bldr, "errorType", ErrorCategory.values()[wfsResult.getToken().getErrorType()]);
        }
        this.addSearchableField(bldr, "parentProcessId", wfsResult.getParentProcessId());
        this.addSearchableField(bldr, LAST_ALLOCATED_RESOURCE_VARIABLE, variables.get(LAST_ALLOCATED_RESOURCE_VARIABLE));
        this.addSearchableField(bldr, HOST_ADDRESS_VARIABLE, variables.get(HOST_ADDRESS_VARIABLE));
        for (String field : this.customMappingFields) {
            if (variables.get(field) == null) continue;
            this.addSearchableField(bldr, field, variables.get(field));
        }
    }

    private boolean isValidId(long providerId) {
        return providerId > -1L;
    }

    private long getLongField(Map<String, WFVariable> variables, String key) {
        if (variables.containsKey(key)) {
            Configuration.toLong((String)variables.get(key).getValue(), (long)-1L);
        }
        return -1L;
    }

    private void addSearchFields(XContentBuilder bldr, WorkflowProcess proc) {
        CustomToken token;
        this.addSearchableField(bldr, "id", proc.getId());
        this.addSearchableField(bldr, "templateId", proc.getProcessDefinition().getId());
        this.addSearchableField(bldr, "templateName", proc.getProcessDefinition().getFullName());
        this.addSearchableField(bldr, "adminStatus", proc.getRootToken().getRequestedStatus());
        this.addSearchableField(bldr, "status", proc.getRootToken().getStatus());
        this.addSearchableField(bldr, "priority", proc.getPriority());
        this.addSearchableField(bldr, "note", proc.getFormatedNotes());
        this.addSearchableField(bldr, "createId", proc.getCreateId());
        TokenVariableMap tMap = proc.getContextInstance().getOrCreateTokenVariableMap((Token)proc.getRootToken());
        LinkedHashSet tMapLocal = new LinkedHashSet(tMap.getVariables().keySet());
        for (String varName : tMapLocal) {
            if ("providerId".equals(varName)) {
                this.addSearchableField(bldr, "providerId", tMap.getVariableInstance(varName).getValue());
                continue;
            }
            if ("titleId".equals(varName)) {
                this.addSearchableField(bldr, "titleId", tMap.getVariableInstance(varName).getValue());
                continue;
            }
            if ("titleBrief".equals(varName)) {
                this.addSearchableField(bldr, "titleBrief", tMap.getVariableInstance(varName).getValue());
                continue;
            }
            if (LICENSING_WINDOW_START.equals(varName)) {
                this.addDateField(tMap, bldr, "licenseStart", varName);
                continue;
            }
            if (LICENSING_WINDOW_END.equals(varName)) {
                this.addDateField(tMap, bldr, "licenseEnd", varName);
                continue;
            }
            if ("ingestTemplate".equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, "ingestTemplate", tMap.getVariableInstance(varName).getValue());
                continue;
            }
            if (LAST_ALLOCATED_RESOURCE_VARIABLE.equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, LAST_ALLOCATED_RESOURCE_VARIABLE, tMap.getVariableInstance(varName).getValue());
                continue;
            }
            if (HOST_ADDRESS_VARIABLE.equalsIgnoreCase(varName)) {
                this.addSearchableField(bldr, HOST_ADDRESS_VARIABLE, tMap.getVariableInstance(varName).getValue());
                continue;
            }
            if (!this.customMappingFields.contains(varName)) continue;
            this.addSearchableField(bldr, varName, tMap.getVariableInstance(varName).getValue());
        }
        this.addSearchableField(bldr, "isActive", proc.isActive());
        this.addSearchableField(bldr, "currentTask", proc.getRootToken().getCurrentNode().getName());
        if (proc.getStart() != null) {
            this.addSearchableField(bldr, "startTime", proc.getStart());
        }
        if (proc.getEnd() != null) {
            this.addSearchableField(bldr, "endTime", proc.getEnd());
        }
        if (proc.getSuperProcessToken() != null) {
            this.addSearchableField(bldr, "superProcessTokenId", proc.getSuperProcessToken().getId());
        } else {
            this.addSearchableField(bldr, "superProcessTokenId", null);
        }
        if (proc.getRootToken().getChildren() != null && proc.getRootToken().getChildren().size() > 0) {
            this.addSearchableField(bldr, "hasChildren", true);
            boolean failed = false;
            for (CustomToken token2 : proc.findAllTokens()) {
                if (token2.isRoot() || token2.getStatus() != ProcessStatus.ERROR || proc.getRootToken().getStatus() != ProcessStatus.BRANCHED) continue;
                failed = true;
            }
            this.addSearchableField(bldr, "hasFailedBranch", failed);
        } else {
            this.addSearchableField(bldr, "hasChildren", false);
            this.addSearchableField(bldr, "hasFailedBranch", false);
        }
        this.addSearchableField(bldr, "rootTokenId", proc.getRootToken().getId());
        if (proc.getRootToken().getErrorDetails() != null) {
            this.addSearchableField(bldr, "errorTime", proc.getRootToken().getErrorDetails().getTime());
            this.addSearchableField(bldr, "errorComment", proc.getRootToken().getErrorDetails().getMessage());
            this.addSearchableField(bldr, "errorType", proc.getRootToken().getErrorDetails().getCategory());
        }
        this.addSearchableField(bldr, "parentProcessId", (token = proc.getSuperProcessToken()) == null ? 0L : token.getProcessInstance().getId());
    }

    private void addDateField(TokenVariableMap tMap, XContentBuilder bldr, String key, String varName) {
        Date dtVal = null;
        if (tMap.getVariableInstance(varName) instanceof DateInstance) {
            dtVal = (Date)tMap.getVariableInstance(varName).getValue();
        } else if (tMap.getVariableInstance(varName) instanceof StringInstance) {
            dtVal = this.convertTitleStringToDate((String)tMap.getVariableInstance(varName).getValue());
        }
        if (dtVal != null) {
            this.addSearchableField(bldr, key, dtVal);
        }
    }

    public void addNormalizedVarSearchField(XContentBuilder bldr, TokenVariableMap tMap, Set<String> tMapLocal) {
        int i;
        String[] normalizedVar = new String[]{"titleId", "titleBrief", "providerId"};
        Object[] normalizedVals = new Object[normalizedVar.length];
        for (String varName : tMapLocal) {
            for (i = 0; i < normalizedVar.length; ++i) {
                if (!normalizedVar[i].equalsIgnoreCase(varName)) continue;
                normalizedVals[i] = tMap.getVariableInstance(varName).getValue();
            }
        }
        for (String varName : tMapLocal) {
            for (i = 0; i < normalizedVar.length; ++i) {
                String key = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, normalizedVar[i]);
                if (normalizedVals[i] != null || !key.equalsIgnoreCase(varName)) continue;
                normalizedVals[i] = tMap.getVariableInstance(varName).getValue();
            }
        }
        for (int i2 = 0; i2 < normalizedVar.length; ++i2) {
            this.addSearchableField(bldr, normalizedVar[i2], normalizedVals[i2]);
        }
    }

    private Date convertTitleStringToDate(String date) {
        Date retVal = null;
        if (date != null && !date.isEmpty()) {
            try {
                retVal = WfsEsParameters.getUTCFormat(date, TimeZone.getTimeZone("UTC")).parse(date);
            }
            catch (ParseException e) {
                LOGGER.warn((Object)("Date received from Title Service [" + date + "] is not in correct format. Expected format :" + "yyyy-MM-dd"), (Throwable)e);
            }
        }
        return retVal;
    }

    private void addSearchableField(XContentBuilder bldr, String key, Object value) {
        try {
            Object localValue = value;
            if (value != null && value instanceof Date) {
                localValue = new Date(((Date)Date.class.cast(value)).getTime());
            }
            bldr.field(key, localValue);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Cannot add a date field: " + key + " for " + value), (Throwable)ex);
        }
    }

    public void addResultProperties(SearchRequestBuilder bld) {
        ArrayList all = Lists.newArrayList();
        all.addAll(this.defaultMappingFields);
        all.addAll(this.customMappingFields);
        bld.setFetchSource(all.toArray(new String[0]), null);
    }

    private Object fetchValue(SearchHit hit, String fieldName) {
        return hit.getSourceAsMap().get(fieldName);
    }

    public long getLongField(SearchHit hit, String fieldName) {
        Object value = this.fetchValue(hit, fieldName);
        return Configuration.toLong((Object)value, (long)0L);
    }

    public String getStringField(SearchHit hit, String fieldName) {
        Object value = this.fetchValue(hit, fieldName);
        return value == null ? "" : value.toString();
    }

    public int getStatusField(SearchHit hit, String fieldName) {
        String value = this.getStringField(hit, fieldName);
        return StringUtils.isBlank((String)value) ? -1 : ProcessStatus.valueOf((String)value).ordinal();
    }

    public int getIntField(SearchHit hit, String fieldName) {
        Object value = this.fetchValue(hit, fieldName);
        return Configuration.toInteger((Object)value, (int)0);
    }

    public Date getDateField(SearchHit hit, String fieldName) throws ParseException {
        Object value = this.fetchValue(hit, fieldName);
        return value == null ? null : WfsEsParameters.getUTCFormat(value.toString(), TimeZone.getTimeZone("UTC")).parse(value.toString());
    }

    public boolean getBooleanField(SearchHit hit, String fieldName) {
        Object value = this.fetchValue(hit, fieldName);
        return Configuration.toBoolean((Object)value, (boolean)false);
    }

    public WFSearchResult convert(SearchHit hit, long totalCount) {
        String superProcessToken;
        String creatId;
        String note;
        Assert.notNull((Object)hit, (String)"SearchHit is null");
        WFSearchResult result = new WFSearchResult();
        result.setProcessId(this.getLongField(hit, "id"));
        if (!this.getStringField(hit, "priority").isEmpty()) {
            String priority = this.getStringField(hit, "priority");
            switch (priority.toUpperCase()) {
                case "LOWEST": {
                    result.setPriority(0);
                    break;
                }
                case "LOW": {
                    result.setPriority(5);
                    break;
                }
                case "NORMAL": {
                    result.setPriority(10);
                    break;
                }
                case "HIGH": {
                    result.setPriority(15);
                    break;
                }
                case "HIGHEST": {
                    result.setPriority(19);
                    break;
                }
                default: {
                    ProcessPriority prioryType = ProcessPriority.valueOf((String)priority);
                    if (prioryType == null) break;
                    result.setPriority(prioryType.ordinal());
                }
            }
        }
        if (!(note = this.getStringField(hit, "note")).isEmpty()) {
            result.setNote(note);
        }
        if (!(creatId = this.getStringField(hit, "createId")).isEmpty()) {
            result.setCreateId(creatId);
        }
        if (!(superProcessToken = this.getStringField(hit, "superProcessTokenId")).isEmpty()) {
            result.setSuperProcessTokenId(this.getLongField(hit, "superProcessTokenId"));
        }
        boolean hasFailedBranch = this.getBooleanField(hit, "hasFailedBranch");
        result.setHasFailedBranch(hasFailedBranch);
        WFToken rootToken = new WFToken();
        rootToken.setTokenId(this.getLongField(hit, "rootTokenId"));
        rootToken.setProcessId(result.getProcessId());
        rootToken.setAdministrativeStatus(this.getStatusField(hit, "adminStatus"));
        rootToken.setOperationalStatus(this.getStatusField(hit, "status"));
        rootToken.setNodeName(this.getStringField(hit, "currentTask"));
        try {
            rootToken.setStartTime(this.getDateField(hit, "startTime"));
            rootToken.setEndTime(this.getDateField(hit, "endTime"));
            rootToken.setErrorTime(this.getDateField(hit, "errorTime"));
            rootToken.setErrorComment(this.getStringField(hit, "errorComment"));
            if (!this.getStringField(hit, "errorType").isEmpty()) {
                rootToken.setErrorType(ErrorCategory.valueOf((String)this.getStringField(hit, "errorType")).ordinal());
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Unknown error to update token status", (Throwable)e);
        }
        result.setToken(rootToken);
        WFVariable titleId = new WFVariable();
        titleId.setName("titleId");
        titleId.addValue(this.getStringField(hit, "titleId"));
        result.addVariable(titleId);
        WFVariable titleBrief = new WFVariable();
        titleBrief.setName("titleBrief");
        titleBrief.addValue(this.getStringField(hit, "titleBrief"));
        result.addVariable(titleBrief);
        String selectorKey = this.getStringField(hit, "ingestTemplate");
        if (selectorKey != null && !selectorKey.isEmpty()) {
            WFVariable ingestTemplate = new WFVariable();
            ingestTemplate.setName("ingestTemplate");
            ingestTemplate.addValue(selectorKey);
            result.addVariable(ingestTemplate);
        }
        WFVariable isActive = new WFVariable();
        isActive.setName("isActive");
        String isActiveStr = this.getStringField(hit, "isActive");
        isActive.addValue(isActiveStr);
        result.addVariable(isActive);
        result.setIsActive(isActiveStr);
        WFVariable templateId = new WFVariable();
        templateId.setName("templateId");
        templateId.addValue(this.getStringField(hit, "templateId"));
        result.addVariable(templateId);
        try {
            Date licenseStartDate = this.getDateField(hit, "licenseStart");
            if (licenseStartDate != null) {
                String licenseStartStr = this.getFormatedDateField(hit, "licenseStart");
                WFVariable licenseStart = new WFVariable();
                licenseStart.setName("licenseStart");
                licenseStart.addValue(licenseStartStr);
                result.addVariable(licenseStart);
                WFVariable licenseStart1 = new WFVariable();
                licenseStart1.setName(LICENSING_WINDOW_START);
                licenseStart1.addValue(licenseStartStr);
                result.addVariable(licenseStart1);
                WFVariable licenseStart2 = new WFVariable();
                licenseStart2.setName(LICENSE_START_LEGACY_KEY);
                licenseStart2.addValue(licenseStartStr);
                result.addVariable(licenseStart2);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Could not parse license start date", (Throwable)e);
        }
        try {
            Date licenseEndDate = this.getDateField(hit, "licenseEnd");
            if (licenseEndDate != null) {
                String licenseEndStr = this.getFormatedDate(licenseEndDate);
                WFVariable licenseEnd = new WFVariable();
                licenseEnd.setName("licenseEnd");
                licenseEnd.addValue(licenseEndStr);
                result.addVariable(licenseEnd);
                WFVariable licenseEnd1 = new WFVariable();
                licenseEnd1.setName(LICENSING_WINDOW_END);
                licenseEnd1.addValue(licenseEndStr);
                result.addVariable(licenseEnd1);
                WFVariable licenseEnd2 = new WFVariable();
                licenseEnd2.setName(LICENSE_END_LEGACY_KEY);
                licenseEnd2.addValue(licenseEndStr);
                result.addVariable(licenseEnd2);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Could not parse license end date", (Throwable)e);
        }
        WFVariable providerId = new WFVariable();
        providerId.setName("providerId");
        providerId.addValue(this.getStringField(hit, "providerId"));
        result.addVariable(providerId);
        if (this.getBooleanField(hit, "hasChildren")) {
            result.addChild(new WFSearchResult());
            while (result.getToken().getAllChildren().size() <= 1) {
                result.getToken().addChild(new WFToken());
            }
        }
        result.setProcessDefinitionName(this.getStringField(hit, "templateName"));
        WFVariable lastAllocatedResource = new WFVariable();
        lastAllocatedResource.setName(LAST_ALLOCATED_RESOURCE_VARIABLE);
        lastAllocatedResource.addValue(this.getStringField(hit, LAST_ALLOCATED_RESOURCE_VARIABLE));
        result.addVariable(lastAllocatedResource);
        WFVariable hostAddress = new WFVariable();
        hostAddress.setName(HOST_ADDRESS_VARIABLE);
        hostAddress.addValue(this.getStringField(hit, HOST_ADDRESS_VARIABLE));
        result.addVariable(hostAddress);
        for (String field : this.customMappingFields) {
            WFVariable variable = new WFVariable();
            variable.setName(field);
            variable.addValue(this.getStringField(hit, field));
            result.addVariable(variable);
        }
        result.setSearchResultCount(totalCount);
        this.setNodeName(result.getProcessDefinitionName(), result.getToken());
        result.setParentProcessId(this.getLongField(hit, "parentProcessId"));
        return result;
    }

    private String getFormatedDateField(SearchHit hit, String key) throws ParseException {
        return this.getFormatedDate(this.getDateField(hit, key));
    }

    private String getFormatedDate(Date date) throws ParseException {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(date);
    }

    private void setNodeName(String templateName, final WFToken token) {
        ITemplateService templateService = (ITemplateService)ServiceRegistry.getDefault().lookup(ITemplateService.class);
        WorkflowTemplate template = templateService.getTemplateByFullName(templateName);
        if (template == null) {
            return;
        }
        template.breadthFirstTraversal(new NodeVisitor(){

            public void visit(Node node) {
                Node currentNode;
                if (node instanceof SuperState && (currentNode = ((SuperState)node).getNode(token.getNodeName())) != null) {
                    token.setNodeName(node.getName());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMappingFields() {
        InputStream defaultMappingInputStream = null;
        try {
            defaultMappingInputStream = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_MAPPING_FILE);
            this.addMappingFields(defaultMappingInputStream, this.defaultMappingFields);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(defaultMappingInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)defaultMappingInputStream);
        FileInputStream customMappingInputStream = null;
        String file = ConfFolder.getWFConfFolder() + "/" + CUSTOM_MAPPING_FILE;
        try {
            customMappingInputStream = new FileInputStream(file);
            this.addMappingFields(customMappingInputStream, this.customMappingFields);
        }
        catch (FileNotFoundException e) {
            try {
                LOGGER.debug((Object)(file + " is not found." + e.getMessage()));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(customMappingInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)customMappingInputStream);
        }
        IOUtils.closeQuietly((InputStream)customMappingInputStream);
    }

    private void addMappingFields(InputStream is, List<String> mappingFields) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode root = objectMapper.readTree(is);
            Iterator nodeIterator = root.findPath("properties").fieldNames();
            while (nodeIterator.hasNext()) {
                String field = (String)nodeIterator.next();
                if (!this.defaultMappingFields.contains(field) && !this.customMappingFields.contains(field)) {
                    mappingFields.add(field);
                    LOGGER.debug((Object)("Added fieldName: " + field));
                    continue;
                }
                LOGGER.warn((Object)("The fieldName: " + field + " already exist."));
            }
        }
        catch (JsonProcessingException jpe) {
            LOGGER.error((Object)("Error occurred while processing " + is), (Throwable)jpe);
        }
        catch (IOException ioe) {
            LOGGER.error((Object)("Error occurred reading " + is), (Throwable)ioe);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Singleton class does not allow cloning!");
    }
}

