/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.DatatypeConverter;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.TypeConversionException;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.entity.TemplateContentTypeEnum;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IMediator;
import com.tandbergtv.workflow.core.event.WorkflowEvent;
import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceEvent;
import com.tandbergtv.workflow.core.service.ServiceEvents;
import com.tandbergtv.workflow.core.service.thread.ISchedulerService;
import com.tandbergtv.workflow.core.service.thread.Scheduler;
import com.tandbergtv.workflow.core.util.TemplateValidator;
import com.tandbergtv.workflow.driver.DriverException;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.IArchivalService;
import com.tandbergtv.workflow.driver.template.ITemplateReader;
import com.tandbergtv.workflow.driver.template.ITemplateService;
import com.tandbergtv.workflow.driver.template.TemplateReaderException;
import com.tandbergtv.workflow.driver.template.event.TemplateEvent;
import com.tandbergtv.workflow.driver.template.event.TemplateEvents;
import com.tandbergtv.workflow.driver.template.internal.ArchivalService;
import com.tandbergtv.workflow.driver.template.internal.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;

public class TemplateLoaderService
implements ITemplateLoaderService {
    private static final int MAX_NAME_LENGTH = 255;
    public static final int MAX_INEST_RETRY_TIMES = 10;
    private static final String SERVICE_NAME = "Template Loader Service";
    private static final Logger LOGGER = Logger.getLogger(TemplateLoaderService.class);
    private ITemplateService templateService;
    private volatile IArchivalService archiver;
    private volatile ISchedulerService<Void> scheduler;
    private int max;
    private LinkedBlockingQueue<UnparsedTemplate> unparsedTemplateQueue = new LinkedBlockingQueue(10000);
    private Cache<String, AtomicInteger> ingestRetryCounter = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(2L, TimeUnit.MINUTES).build();
    private CompilerTask compilerTask = new CompilerTask();
    private volatile boolean cacheLoaded;
    private Map<String, Callable<Void>> postTasks = Maps.newLinkedHashMap();

    public TemplateLoaderService(int maxTemplateAmount, ITemplateService templateService) {
        this.max = maxTemplateAmount;
        this.templateService = templateService;
        this.scheduler = this.getScheduler();
        this.archiver = this.getArchiver();
    }

    public ISchedulerService<Void> getScheduler() {
        if (this.scheduler == null) {
            return new Scheduler("template", 1, 1);
        }
        return this.scheduler;
    }

    public void setScheduler(ISchedulerService<Void> scheduler) {
        this.scheduler = scheduler;
    }

    public IArchivalService getArchiver() {
        if (this.archiver == null) {
            this.archiver = new ArchivalService(this.scheduler);
        }
        return this.archiver;
    }

    public void setArchiver(IArchivalService archiver) {
        this.archiver = archiver;
    }

    public ITemplateService getTemplateService() {
        return this.templateService;
    }

    public void setTemplateService(ITemplateService templateService) {
        this.templateService = templateService;
    }

    public int getUningestedTemplateNumber() {
        return this.unparsedTemplateQueue.size();
    }

    public int getTemplateIngestRetryCount(String fullName) {
        AtomicInteger counter = this.getIngestRetryCounter(fullName);
        return counter == null ? 0 : counter.get();
    }

    @Override
    public void runCompiler(File file, ITemplateReader reader) {
        this.unparsedTemplateQueue.offer(new UnparsedTemplate(file, reader));
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void start() {
        this.scheduler.schedule((Callable)new CacheLoader());
        this.scheduler.schedule((Runnable)this.compilerTask, 0L, 10000L);
    }

    public void stop() {
        this.archiver.stop();
        this.scheduler.stop();
        IMediator mediator = DefaultMediator.getInstance();
        mediator.sendAsync((WorkflowEvent)new ServiceEvent((Service)this, ServiceEvents.STOPPED));
    }

    protected void save(File file, WorkflowTemplate template, String xmlContent) throws DriverException {
        this.checkLicense(template);
        this.checkVersion(template.getName(), template.getVersion());
        this.checkTemplateName(file, template.getName());
        this.checkNode(template);
        this.checkStartVariable(template);
        this.checkReferencedSubprocess(template);
        Files.unzipArchive(template, file);
        this.templateService.create(template, xmlContent, TemplateContentTypeEnum.JPDL_XML);
        this.archiver.run(template);
        if (!Files.success(file)) {
            LOGGER.warn((Object)("Failed to move Template file " + this.getTemplateKey(file)));
        }
    }

    private void checkTemplateName(File file, String name) throws DriverException {
        if (this.isLongInvalidName(name)) {
            throw new DriverException("The name of Template on: " + this.getTemplateKey(file) + " is too long, it has to less than 256 characters.");
        }
    }

    private void checkNode(WorkflowTemplate template) throws DriverException {
        this.checkNodeDuplicatedName(template);
        this.checkBrokenNodes(template);
        this.checkNodeNameLength(template);
    }

    private void ingest(List<UnparsedTemplate> files, boolean firstRun) {
        ArrayList pending = Lists.newArrayList();
        for (UnparsedTemplate unparsed : files) {
            File file = unparsed.file;
            ITemplateReader reader = unparsed.reader;
            WorkflowTemplate template = null;
            String xmlContent = null;
            try {
                unparsed.template = template = reader.read();
                xmlContent = reader.getXmlContent();
                List<String> unresolvedRefer = this.findUnresolvedRefers(template);
                if (!unresolvedRefer.isEmpty()) {
                    this.addToPendingList(pending, unparsed, unresolvedRefer);
                    continue;
                }
                this.fireEvent(file, template, TemplateEvents.COMPILED);
                this.save(file, template, xmlContent);
            }
            catch (TemplateReaderException e) {
                this.handleTemplateReaderError(pending, unparsed, e);
            }
            catch (Exception e) {
                this.rejectTemplate(unparsed, e);
            }
        }
        if (!pending.isEmpty()) {
            if (firstRun) {
                this.ingest(pending, false);
            } else {
                this.addToQueueForRetry(pending);
            }
        }
    }

    private void handleTemplateReaderError(List<UnparsedTemplate> pending, UnparsedTemplate unparsed, TemplateReaderException e) {
        if (e.hasTemplateFullName()) {
            try {
                this.checkVersion(e.getTemplateName(), e.getTemplateVersion());
            }
            catch (DriverException ce) {
                this.rejectTemplate(unparsed, ce);
                return;
            }
        }
        if (e.hasUnresolvedReferences()) {
            this.addToPendingList(pending, unparsed, e.getUnresolvedReferences());
        } else {
            this.rejectTemplate(unparsed, (Exception)((Object)e));
        }
    }

    private String getTemplateKey(File file) {
        return file == null ? "" : file.getAbsolutePath();
    }

    private void rejectTemplate(UnparsedTemplate unparsed, Exception e) {
        this.die(unparsed.file, unparsed.template, e);
        this.invalidateIngestRetryCounter(this.getTemplateKey(unparsed.file));
    }

    private void addToPendingList(List<UnparsedTemplate> pending, UnparsedTemplate unparsed, List<String> unresolvedRefer) {
        unparsed.setUnResolvedRefers(unresolvedRefer);
        pending.add(unparsed);
    }

    private void addToQueueForRetry(List<UnparsedTemplate> pending) {
        for (UnparsedTemplate unparsedTemplate : pending) {
            String templateKey = this.getTemplateKey(unparsedTemplate.file);
            AtomicInteger counter = this.getIngestRetryCounter(templateKey);
            if (counter != null && counter.getAndIncrement() < 10) {
                this.unparsedTemplateQueue.offer(unparsedTemplate);
                LOGGER.info((Object)("Cannot find referenced Template" + unparsedTemplate.getUnresovledRefName() + " for Template<" + templateKey + ">, pend the ingestion to next round , the number of retries is " + counter.get() + " . "));
                continue;
            }
            TemplateReaderException error = new TemplateReaderException("Failed to find resovled referenence :" + unparsedTemplate.getUnresovledRefName() + " after " + 10 + " retries.");
            this.rejectTemplate(unparsedTemplate, (Exception)((Object)error));
        }
    }

    private void invalidateIngestRetryCounter(String temlateKey) {
        this.ingestRetryCounter.invalidate((Object)temlateKey);
    }

    private AtomicInteger getIngestRetryCounter(String templateName) {
        AtomicInteger counter = null;
        try {
            counter = (AtomicInteger)this.ingestRetryCounter.get((Object)templateName, () -> new AtomicInteger(0));
        }
        catch (ExecutionException e) {
            LOGGER.warn((Object)("Unhandled exception on creating the retry counter for Template<" + templateName + ">"), (Throwable)e);
        }
        return counter;
    }

    private List<String> findUnresolvedRefers(WorkflowTemplate template) {
        ArrayList unsolved = Lists.newArrayList();
        for (String name : template.getSubTemplateNames()) {
            if (this.getTemplateService().getTemplateByName(name) != null) continue;
            unsolved.add(name);
        }
        return unsolved;
    }

    private void checkLicense(WorkflowTemplate template) throws DriverException {
        int count = this.getLicenseCount();
        for (WorkflowTemplate t : this.templateService.getLatestTemplates()) {
            if (!t.getName().equals(template.getName())) continue;
            return;
        }
        if (this.templateService.getLatestTemplates().size() >= count) {
            throw new DriverException("License unavailable for template " + template.getFullName() + ", limit = " + count);
        }
    }

    private void checkVersion(String templateName, int version) throws DriverException {
        WorkflowTemplate latest = this.templateService.getTemplateByName(templateName);
        if (latest != null && latest.getVersion() >= version) {
            throw new DriverException("Template<" + templateName + "> - version must exceed " + latest.getVersion());
        }
        if (this.templateService.isExistedActiveVersion(templateName, version)) {
            throw new DriverException("Template <" + templateName + "> - version  " + version + " aleady exists in system");
        }
        if (this.templateService.isExistedInLegacyModel(templateName, version)) {
            throw new DriverException("Template <" + templateName + "> - version  " + version + " aleady exists in JBPM legacy model, cannot re-ingest it now, please run migration tool to activate it");
        }
    }

    private void checkNodeDuplicatedName(WorkflowTemplate template) throws DriverException {
        List duplicated = template.findDuplicatedNodeNames();
        if (!duplicated.isEmpty()) {
            String error = "Failed to load the Template<" + template + ">, Found duplicated Nodes [ " + StringUtils.join((Collection)duplicated, (String)",") + "] in it.";
            throw new DriverException(error);
        }
    }

    private void checkNodeNameLength(WorkflowTemplate template) throws DriverException {
        ArrayList longNameNodes = Lists.newArrayList();
        for (Node node : template.getAllNodes()) {
            if (!this.isLongInvalidName(node.getName())) continue;
            longNameNodes.add(node.getName());
        }
        if (!longNameNodes.isEmpty()) {
            String error = "Failed to load the Template<" + template + ">, part of nodes name are too long, they have to less than 256 characters. \n Please check node  [ " + StringUtils.join((Collection)longNameNodes, (String)",") + "] in it.";
            throw new DriverException(error);
        }
    }

    private boolean isLongInvalidName(String name) {
        return name != null && name.length() > 255;
    }

    private void checkBrokenNodes(WorkflowTemplate template) throws DriverException {
        try {
            TemplateValidator.noBrokenNodes((WorkflowTemplate)template);
        }
        catch (IllegalArgumentException e) {
            String error = "Failed to load the Template<" + template.getFullName() + ">. ";
            LOGGER.error((Object)error, (Throwable)e);
            throw new DriverException(error + " " + e.getMessage());
        }
    }

    private void checkStartVariable(WorkflowTemplate template) throws DriverException {
        Collection variables = template.getStartTaskVariables();
        if (variables == null || variables.isEmpty()) {
            return;
        }
        for (TaskVariable variable : variables) {
            if (variable.getInitialValue() == null) continue;
            try {
                DatatypeConverter.convert((Object)variable.getInitialValue(), (Datatype)variable.getDatatype());
            }
            catch (TypeConversionException e) {
                String error = "Failed to load the Template< " + template + ">, Found invalid start variables. " + e.getCombinedMessage();
                throw new DriverException(error);
            }
        }
    }

    void checkReferencedSubprocess(WorkflowTemplate template) throws DriverException {
        if (!template.hasSubProcess()) {
            return;
        }
        List<WorkflowTemplate> referenced = this.templateService.findReferencedTemplate(template);
        if (!referenced.isEmpty()) {
            WorkflowTemplate first = referenced.get(0);
            String msg = "Current Template has sub template, but Current template is also the sub template of  Template<" + first + ">. Failed to ingest it";
            throw new DriverException(msg);
        }
    }

    private void die(File file, WorkflowTemplate template, Exception e) {
        this.logError(file, e);
        this.fireEvent(file, template, TemplateEvents.COMPILE_ERROR);
        Files.reject(file);
    }

    private void logError(File file, Exception e) {
        String message = "Failed to ingest Template from file:" + this.getTemplateKey(file) + ". ";
        if (this.isKnownException(e)) {
            LOGGER.error((Object)(message + " --" + this.extractSlimErrorMessage(e) + ""));
        } else {
            LOGGER.error((Object)message, (Throwable)e);
        }
    }

    private boolean isKnownException(Exception e) {
        return e != null && (e instanceof TemplateReaderException || e instanceof DriverException);
    }

    private String extractSlimErrorMessage(Exception e) {
        String mString = ExceptionUtils.getRootCauseMessage((Throwable)e);
        if (e instanceof TemplateReaderException) {
            mString = ((TemplateReaderException)((Object)TemplateReaderException.class.cast(e))).getErroProblemMessage();
        }
        return mString;
    }

    private void fireEvent(Object source, WorkflowTemplate template, TemplateEvents type) {
        DefaultMediator.getInstance().sendAsync((WorkflowEvent)new TemplateEvent(source, template, type));
    }

    private int getLicenseCount() {
        return this.max;
    }

    public void addPostTaskAfterCachLoaded(String taskName, Callable<Void> callable) {
        if (this.cacheLoaded) {
            LOGGER.info((Object)("The Template cache is ready, executing the Task[" + taskName + "]"));
            try {
                callable.call();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to start the Task[" + taskName + "]", e);
            }
        } else {
            this.postTasks.put(taskName, callable);
        }
    }

    private final class CacheLoader
    implements Callable<Void> {
        private CacheLoader() {
        }

        @Override
        public Void call() throws Exception {
            try {
                TemplateLoaderService.this.cacheLoaded = false;
                TemplateLoaderService.this.templateService.loadActiveTemplates();
                DefaultMediator.getInstance().sendAsync((WorkflowEvent)new ServiceEvent((Service)TemplateLoaderService.this, ServiceEvents.STARTED));
            }
            catch (Throwable e) {
                LOGGER.error((Object)"Failed to load templates", e);
            }
            TemplateLoaderService.this.cacheLoaded = true;
            this.startPostTasks();
            TemplateLoaderService.this.archiver.start();
            return null;
        }

        private void startPostTasks() {
            if (TemplateLoaderService.this.postTasks.isEmpty()) {
                return;
            }
            LOGGER.info((Object)"Template cache is ready now, starting the registerd post tasks.. ");
            for (Map.Entry entry : TemplateLoaderService.this.postTasks.entrySet()) {
                LOGGER.info((Object)("Starting the Task[" + (String)entry.getKey() + "]"));
                try {
                    ((Callable)entry.getValue()).call();
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Failed to start Task[" + (String)entry.getKey() + "]"), (Throwable)e);
                }
            }
        }
    }

    private final class UnparsedTemplate {
        public WorkflowTemplate template;
        File file;
        ITemplateReader reader;
        List<String> unresolvedRefers = Lists.newArrayList();

        UnparsedTemplate(File file, ITemplateReader reader) {
            this.file = file;
            this.reader = reader;
        }

        public void setUnResolvedRefers(List<String> unresolvedRefers) {
            this.unresolvedRefers.clear();
            this.unresolvedRefers.addAll(unresolvedRefers);
        }

        public String getUnresovledRefName() {
            return "<" + StringUtils.join(this.unresolvedRefers, (String)",") + ">";
        }
    }

    private final class CompilerTask
    implements Runnable {
        private CompilerTask() {
        }

        @Override
        public void run() {
            if (TemplateLoaderService.this.unparsedTemplateQueue.isEmpty()) {
                return;
            }
            LOGGER.info((Object)("Got " + TemplateLoaderService.this.unparsedTemplateQueue.size() + " template files to ingest."));
            ArrayList toHandle = Lists.newArrayList();
            TemplateLoaderService.this.unparsedTemplateQueue.drainTo(toHandle);
            if (!toHandle.isEmpty()) {
                TemplateLoaderService.this.ingest(toHandle, true);
            }
        }
    }
}

