/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template;

import com.tandbergtv.workflow.core.Selector;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.TypeConversionException;
import com.tandbergtv.workflow.core.VariableHashMap;
import com.tandbergtv.workflow.core.WorkflowTemplate;
import com.tandbergtv.workflow.core.entity.SelectorKey;
import com.tandbergtv.workflow.core.entity.TemplateContentTypeEnum;
import com.tandbergtv.workflow.core.entity.WorkflowTemplateDTO;
import com.tandbergtv.workflow.core.entity.WorkflowTemplateTypeId;
import com.tandbergtv.workflow.core.graph.NodeVisitor;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.core.util.JsonObjectMapper;
import com.tandbergtv.workflow.core.util.TemplateValidator;
import com.tandbergtv.workflow.driver.template.ITemplateCoderFactory;
import com.tandbergtv.workflow.driver.template.NodeTimeoutGetter;
import com.tandbergtv.workflow.driver.template.NodeTimeoutSetter;
import com.tandbergtv.workflow.driver.template.SelectorKeyConvertor;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class TemplateObjectConvertor {
    private static final Logger logger = Logger.getLogger(TemplateObjectConvertor.class);
    private volatile ITemplateCoderFactory coderFactory;

    public WorkflowTemplateDTO toTemplateDTO(WorkflowTemplate template, String jpdlContent, TemplateContentTypeEnum contentType) {
        WorkflowTemplateDTO templateDto = new WorkflowTemplateDTO();
        long templateId = template.getId();
        Assert.isTrue((!template.isNew() ? 1 : 0) != 0, (String)"No Id assignment for current template Object");
        templateDto.setId(templateId);
        templateDto.setName(template.getName());
        templateDto.setVersion(template.getVersion());
        templateDto.setTypeId(WorkflowTemplateTypeId.ACTIVE);
        templateDto.setContentType(contentType);
        templateDto.setProcessDefinition(jpdlContent);
        templateDto.setNodeTimeouts(TemplateObjectConvertor.getTemplateNodeTimeouts(template));
        templateDto.setVariables(TemplateObjectConvertor.getTempalateVariables(template));
        templateDto.setCreateDate(new Date());
        return templateDto;
    }

    private static String getTempalateVariables(WorkflowTemplate template) {
        Collection taskVars = template.getStartTaskVariables();
        VariableHashMap dtoVars = new VariableHashMap();
        for (TaskVariable taskVar : taskVars) {
            dtoVars.put(taskVar.getVariableName(), (Object)taskVar.getInitialValue());
        }
        return JsonObjectMapper.toJsonString((VariableHashMap)dtoVars);
    }

    private static String getTemplateNodeTimeouts(WorkflowTemplate template) {
        VariableHashMap dtoNodeTimeouts = new VariableHashMap();
        template.greedyBreadthFirstTraversal((NodeVisitor)new NodeTimeoutGetter((Map<String, Object>)dtoNodeTimeouts));
        return JsonObjectMapper.toJsonString((VariableHashMap)dtoNodeTimeouts);
    }

    public WorkflowTemplate toTemplate(WorkflowTemplateDTO templateDto) {
        if (templateDto == null) {
            return null;
        }
        logger.debug((Object)("Parsing Template DTO content to WorkflowTemplate: " + ObjectUtils.toString((Object)templateDto, (String)" null")));
        WorkflowTemplate template = this.decodeTemplate(templateDto);
        template.setId(templateDto.getId());
        template.setName(templateDto.getName());
        template.setVersion(templateDto.getVersion());
        template.setCreateDate(templateDto.getCreateDate());
        template.setActive(templateDto.isActive());
        TemplateValidator.noBrokenNodes((WorkflowTemplate)template);
        try {
            Map variables = JsonObjectMapper.toMap((String)templateDto.getVariables());
            template.setStartTaskVariables(variables);
        }
        catch (TypeConversionException e) {
            logger.error((Object)("Error in parsing Template<" + templateDto.getFullName() + "> 's start task variables. " + e.getCombinedMessage()));
        }
        String nodeTimeouts = templateDto.getNodeTimeouts();
        logger.debug((Object)("Node Time out Info :" + nodeTimeouts));
        template.greedyBreadthFirstTraversal((NodeVisitor)new NodeTimeoutSetter(templateDto.getNodeTimeoutsMap()));
        for (SelectorKey selectorKey : templateDto.getSelectorKeys()) {
            Selector selector = new SelectorKeyConvertor().toSelector(selectorKey);
            template.addSelectorKey(selector);
        }
        return template;
    }

    private WorkflowTemplate decodeTemplate(WorkflowTemplateDTO dto) {
        Assert.notNull((Object)dto.getContentType(), (String)(dto.getFullName() + " Template ContentType should not be null."));
        Assert.notNull((Object)dto.getProcessDefinition(), (String)(dto.getFullName() + " Template Definition should not be null."));
        return this.getTemplateCoderFactory().create(dto.getContentType()).decode(dto.getProcessDefinition());
    }

    private ITemplateCoderFactory getTemplateCoderFactory() {
        if (this.coderFactory == null) {
            this.coderFactory = (ITemplateCoderFactory)ServiceRegistry.getDefault().lookup(ITemplateCoderFactory.class);
        }
        return this.coderFactory;
    }

    public void setCoderFactory(ITemplateCoderFactory coderFactory) {
        this.coderFactory = coderFactory;
    }
}

