/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.template.internal;

import com.tandbergtv.workflow.core.WorkflowTemplate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.jbpm.util.IoUtil;

public class Files {
    private static final String REJECTED = "rejected";
    private static final String IMPORTED = "imported";
    private static final Logger LOGGER = Logger.getLogger(Files.class);

    private Files() {
    }

    public static boolean success(File file) {
        return Files.move(file.getParentFile().getParentFile() + File.separator + IMPORTED, file);
    }

    public static boolean reject(File file) {
        return Files.move(file.getParentFile().getParentFile() + File.separator + REJECTED, file);
    }

    public static void unzipArchive(WorkflowTemplate template, File file) {
        try (FileInputStream in = new FileInputStream(file);){
            ZipInputStream zipInputStream = new ZipInputStream(in);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String entryName = zipEntry.getName();
                byte[] bytes = IoUtil.readBytes((InputStream)zipInputStream);
                template.getFileDefinition().addFile(entryName, bytes);
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (IOException e) {
            LOGGER.warn((Object)("Failed to read template entry: " + file.getAbsolutePath()), (Throwable)e);
        }
    }

    private static boolean move(String dir, File file) {
        String time = new SimpleDateFormat("yyyy-MM-dd-HHmmSS").format(new Date());
        String filename = file.getName();
        String basename = FilenameUtils.getBaseName((String)filename);
        String extension = FilenameUtils.getExtension((String)filename);
        String movedFileName = dir + File.separator + filename.replace(".", "-") + "-" + time;
        if (!extension.isEmpty()) {
            movedFileName = movedFileName + "." + extension;
        }
        boolean moved = file.renameTo(new File(movedFileName));
        Files.renameSubFile(basename + ".jpdl", file, dir, time);
        Files.renameSubFile(basename + ".gpd", file, dir, time);
        return moved;
    }

    private static void renameSubFile(String oldFileName, File targetFile, String dir, String timestamp) {
        boolean renamed;
        File subFile = new File(targetFile.getParentFile(), oldFileName);
        boolean bl = renamed = subFile.exists() && subFile.renameTo(new File(dir, subFile.getName() + "-" + timestamp));
        if (!renamed) {
            LOGGER.warn((Object)("rename file fail: " + subFile.getName() + "-" + timestamp));
        }
    }
}

