/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.Datatype;
import com.tandbergtv.workflow.core.DatatypeConverter;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.TaskVariable;
import com.tandbergtv.workflow.core.graph.ErrorCategory;
import com.tandbergtv.workflow.core.graph.exe.IExecutable;
import com.tandbergtv.workflow.exe.ActionException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;

public abstract class AbstractAction
implements IExecutable {
    private static final long serialVersionUID = 1L;
    private boolean aborted;
    private volatile Thread currentThread = null;
    private volatile CustomToken token = null;

    public final void abort() {
        this.aborted = true;
        if (this.currentThread != null && ProcessStatus.getActiveSet().contains(this.token.getStatus())) {
            this.currentThread.interrupt();
            this.getLogger().info((Object)(this.currentThread.getName() + " is interrupted by AbstractAction.abort"));
        }
    }

    public void cleanup() {
    }

    public final void execute(ExecutionContext context) throws Exception {
        this.currentThread = Thread.currentThread();
        this.token = (CustomToken)context.getToken();
        this.validateTokenStatus();
        try {
            this.start(context);
        }
        catch (CancellationException e) {
            this.handleTimeoutException(e);
        }
        catch (Exception e) {
            this.handleActionException(e);
        }
    }

    private void validateTokenStatus() {
        if (this.token.getStatus() == ProcessStatus.ERROR || this.token.getRequestedStatus() == ProcessStatus.ERROR) {
            String msg = this.token.isResumeAfterFail() ? ErrorCategory.RESOURCE_FAILED.name() : ErrorCategory.TIMEOUT.name();
            throw new ActionException(msg);
        }
    }

    protected void handleActionException(Exception e) {
        this.handleTimeoutException(e);
        if (e instanceof ActionException) {
            throw (ActionException)e;
        }
        Throwable cause = e.getCause();
        this.getLogger().error((Object)("Fail to execute the current message , " + ExceptionUtils.getRootCauseMessage((Throwable)cause)));
        if (cause instanceof ActionException) {
            throw (ActionException)cause;
        }
        cause = ExceptionUtils.getRootCause((Throwable)e);
        if (cause instanceof ActionException) {
            throw (ActionException)cause;
        }
        if (cause instanceof ExecutionException) {
            throw new ActionException(cause);
        }
        throw new ActionException(e);
    }

    private void handleTimeoutException(Exception e) {
        if ((e instanceof CancellationException || e instanceof ActionException && ExceptionUtils.getRootCause((Throwable)e) instanceof InterruptedException) && this.aborted) {
            this.getLogger().info((Object)("Cancel the current message, due to " + e.getMessage()));
            throw new ActionException(ErrorCategory.TIMEOUT.name(), e);
        }
    }

    protected abstract void start(ExecutionContext var1);

    protected void setContextVariable(ExecutionContext context, TaskVariable variable, String name, Object value) {
        try {
            Object typedValue = value == null ? value : DatatypeConverter.convert((Object)value, (Datatype)variable.getDatatype());
            context.setVariable(name, typedValue);
        }
        catch (Exception e) {
            String message = context.getToken() + ", failed to convert variable " + name + "," + value;
            this.getLogger().error((Object)message, (Throwable)e);
        }
    }

    private Logger getLogger() {
        return Logger.getLogger(this.getClass());
    }
}

