/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.exe.token;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.ProcessStatus;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.internal.callable.CancelToken;
import com.tandbergtv.workflow.driver.internal.callable.SignalSuperProcessToken;
import com.tandbergtv.workflow.driver.internal.callable.TokenCallable;
import com.tandbergtv.workflow.driver.internal.callable.UndoSuperProcessToken;
import com.tandbergtv.workflow.driver.monitor.IProcessCounter;
import com.tandbergtv.workflow.exe.token.AbstractTokenHandler;
import org.apache.log4j.Logger;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

public class End
extends AbstractTokenHandler {
    private static final long serialVersionUID = 2322699262929474682L;
    private static final Logger LOGGER = Logger.getLogger(End.class);

    public void execute(ExecutionContext context) throws Exception {
        CustomToken token = (CustomToken)CustomToken.class.cast(context.getToken());
        if (token.getRequestedStatus() == ProcessStatus.CANCELLED) {
            this.cancel(token);
        } else {
            this.stop(token);
        }
    }

    private void stop(CustomToken token) {
        if (!token.isRoot()) {
            return;
        }
        CustomToken superProcessToken = token.getProcessInstance().getSuperProcessToken();
        if (superProcessToken == null) {
            LOGGER.debug((Object)("No running parent token found for token " + token + ", It might has been completed "));
            return;
        }
        WorkflowProcess subProcess = token.getProcessInstance();
        subProcess.setSuperProcessToken((Token)superProcessToken);
        superProcessToken.setSubProcessInstance((ProcessInstance)subProcess);
        try {
            this.localCall(new SignalSuperProcessToken(superProcessToken, subProcess));
        }
        catch (Exception e) {
            LOGGER.debug((Object)(token + " could not notify parent " + superProcessToken + " at first time, try it again."), (Throwable)e);
            try {
                this.localCall(new SignalSuperProcessToken(superProcessToken, subProcess));
            }
            catch (Exception e1) {
                LOGGER.warn((Object)(token + " could not notify parent " + superProcessToken), (Throwable)e1);
            }
        }
    }

    private void cancel(CustomToken token) {
        for (CustomToken child : token.getActiveChildTokens()) {
            try {
                this.cancelImmediate(child);
            }
            catch (Exception e) {
                LOGGER.warn((Object)(token + ", execution failed"), (Throwable)e);
            }
        }
        WorkflowProcess child = token.getSubProcessInstance();
        if (child != null) {
            this.localCall(new CancelToken(child.getRootToken()));
        }
        if (this.mustUndoSuperProcessToken(token)) {
            this.localCall(new UndoSuperProcessToken(token.getProcessInstance().getSuperProcessToken()));
        }
    }

    private void localCall(TokenCallable token) {
        try {
            token.call();
        }
        catch (Exception e) {
            LOGGER.warn((Object)(token + ", execution failed"), (Throwable)e);
        }
    }

    private boolean mustUndoSuperProcessToken(CustomToken token) {
        WorkflowProcess process = token.getProcessInstance();
        return token.isRoot() && process.getSuperProcessToken() != null && process.getContextInstance().hasTransientVariable("_undo_");
    }

    private void cancelImmediate(CustomToken token) {
        IProcessCounter counter = (IProcessCounter)((Object)this.getService().getStatistics().getCumulativeStatistics());
        token.cancel();
        counter.cancelled(token);
    }
}

