/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.dataaccess.hibernate;

import com.tandbergtv.workflow.dao.HibernateDAO;
import com.tandbergtv.workflow.resourcemanager.dataaccess.ResourceGroupDAI;
import com.tandbergtv.workflow.resourcemanager.entities.ResourceGroup;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;

public class ResourceGroupHDAO
extends HibernateDAO<ResourceGroup, Long>
implements ResourceGroupDAI {
    public ResourceGroupHDAO(Session session) {
        super(ResourceGroup.class, session);
    }

    @Override
    public List<ResourceGroup> findByResourceType(long resourceTypeId) {
        Criteria criteria = this.createCriteria(new Criterion[0]).createCriteria("resourceType");
        criteria = criteria.add(Restrictions.idEq((Object)resourceTypeId));
        return this.findByCriteria(criteria);
    }

    @Override
    public List<ResourceGroup> findByResource(long resourceId) {
        Criteria criteria = this.createCriteria(new Criterion[0]).createCriteria("resources");
        criteria = criteria.add(Restrictions.idEq((Object)resourceId));
        return this.findByCriteria(criteria);
    }

    @Override
    public Long findResourceTypeIDByKey(long resourceGroupId) {
        String queryString = "SELECT resourceGroup.resourceType.id FROM ResourceGroup resourceGroup WHERE resourceGroup.id = :resourceGroupId";
        Query query = this.getSession().createQuery(queryString);
        query.setParameter("resourceGroupId", (Object)new Long(resourceGroupId));
        return (Long)query.uniqueResult();
    }

    @Override
    public ResourceGroup findByName(String name) {
        String queryString = "SELECT resourceGroup FROM ResourceGroup resourceGroup WHERE resourceGroup.name = :name";
        Query query = this.getSession().createQuery(queryString);
        query.setParameter("name", (Object)name);
        return (ResourceGroup)query.uniqueResult();
    }

    @Override
    public Long findResourceTypeByGroupName(String resourceGroupName) {
        String queryString = "SELECT resourceGroup.resourceType.id FROM ResourceGroup resourceGroup WHERE resourceGroup.name = :resourceGroupName";
        Query query = this.getSession().createQuery(queryString);
        query.setParameter("resourceGroupName", (Object)resourceGroupName);
        return (Long)query.uniqueResult();
    }
}

