/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.resourcemanager.internal.callable;

import com.tandbergtv.workflow.core.service.Service;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.resourcemanager.ResourceManagement;
import com.tandbergtv.workflow.resourcemanager.ResourceManagementNotReadyException;
import com.tandbergtv.workflow.resourcemanager.internal.IResourceManagementInternal;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public abstract class ResourceManagementCallable<V>
implements Callable<V>,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(ResourceManagementCallable.class);
    private static final long serialVersionUID = -8973305533391693093L;
    private static final long TIMEOUT = 10000L;
    private static final int RETRY_COUNT = 5;
    private long createTime = System.currentTimeMillis();

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    @Override
    public V call() throws Exception {
        long start = System.currentTimeMillis();
        for (int count = 0; !this.isResourceManagerStarted() && count < 5; ++count) {
            Thread.sleep(10000L);
        }
        if (!this.isResourceManagerStarted()) {
            String msg = "The Resource Management Service is not ready.";
            throw new ResourceManagementNotReadyException(msg);
        }
        V result = this.performTask();
        long cost = System.currentTimeMillis() - start;
        if (cost > 30000L) {
            LOGGER.warn((Object)("PERF:The task took " + cost + " ms to execute the Handler for event->  " + this.getTaskInfo()));
        }
        return result;
    }

    protected String getTaskInfo() {
        return "class:" + this.getClass().getSimpleName();
    }

    protected abstract V performTask() throws Exception;

    protected ResourceManagement getResourceManagementService() {
        ServiceRegistry registry = ServiceRegistry.getDefault();
        return (ResourceManagement)registry.lookup(ResourceManagement.class);
    }

    protected ServiceRegistry getInternalRegistry() {
        return ((IResourceManagementInternal)this.getResourceManagementService()).getLocalRegistry();
    }

    protected <T extends Service> T getService(Class<T> clazz) {
        return (T)((Service)this.getInternalRegistry().lookup(clazz));
    }

    protected <T extends Service> T getService(String name) {
        return (T)this.getInternalRegistry().lookup(name);
    }

    private boolean isResourceManagerStarted() {
        ResourceManagement manager = this.getResourceManagementService();
        return manager != null && manager.isStarted();
    }
}

