/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.driver.search;

import com.tandbergtv.workflow.driver.search.ListParameter;
import com.tandbergtv.workflow.driver.search.OrParameterMap;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SortingOrder;
import org.apache.log4j.Logger;

public abstract class SearchParameterBase {
    protected static final Logger LOGGER = Logger.getLogger(SearchParameterBase.class);
    private static final String VALUE_PROPERTY = "value";
    public static final String PROCESS_ALIAS = "process";
    public static final String WORKFLOW_TEMPLATE_ALIAS = "template";
    public static final String TOKEN_ALIAS = "token";
    protected String fieldName = null;
    protected SearchType fieldType = null;
    protected boolean varInstance;
    protected String alias = null;
    protected int objectCount;
    protected SortingOrder sortingOrder;
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_BETTER_HQL = "yyyy-mm-dd hh24:mi:ss";
    public static final String DATE_FORMAT_FULL_LONG = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected boolean ignoreCase;

    protected SearchParameterBase(String name) {
        this(name, SearchType.STRING);
    }

    protected SearchParameterBase(String name, SearchType fieldType) {
        this(name, fieldType, false);
    }

    protected SearchParameterBase(String name, SearchType fieldType, boolean varInstance) {
        this.fieldName = name;
        this.fieldType = fieldType;
        this.varInstance = varInstance;
    }

    public boolean isVarInstance() {
        return this.varInstance;
    }

    public void setVarInstance(boolean varInstance) {
        this.varInstance = varInstance;
    }

    public SearchType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(SearchType fieldType) {
        this.fieldType = fieldType;
    }

    public String getAlias() {
        return this.alias;
    }

    void setAlias(String alias) {
        this.alias = alias;
    }

    void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public SortingOrder getSortingOrder() {
        return this.sortingOrder;
    }

    public void setSortingOrder(SortingOrder sortingOrder) {
        this.sortingOrder = sortingOrder;
    }

    public String getPartialFromClause(int count) {
        this.objectCount = count;
        String fromClause = "";
        if (this.fieldName.equals("tokenstatus")) {
            fromClause = "CustomToken token" + this.objectCount;
        } else {
            this.alias = PROCESS_ALIAS;
        }
        return fromClause;
    }

    protected String getVariableInstanceType() {
        if (!this.isVarInstance()) {
            LOGGER.error((Object)"Invalid search parameter, cannot return variableInstanceType for non-variableInstances.");
            return null;
        }
        return this.getVarInstanceTypeFromSearchType();
    }

    private String getVarInstanceTypeFromSearchType() {
        switch (this.fieldType) {
            case STRING: {
                return "StringInstance";
            }
            case NUMERIC: {
                return "LongInstance";
            }
            case DATE: {
                return "DateInstance";
            }
        }
        return null;
    }

    public String getSortingColumn() {
        if (this.sortingOrder == null) {
            throw new RuntimeException("Invalid attempt at getting sorting column for not sorting paramter " + this.fieldName + ".");
        }
        if (!this.isVarInstance()) {
            return this.fieldName;
        }
        if (!(this instanceof SortParameter)) {
            return VALUE_PROPERTY;
        }
        switch (this.fieldType) {
            case STRING: {
                return "stringVal";
            }
            case NUMERIC: {
                return "doubleVal";
            }
            case DATE: {
                return "dateVal";
            }
        }
        return null;
    }

    public String getPartialWhereClause() {
        String whereClause = "";
        if (this instanceof OrParameterMap) {
            return this.getPredicate();
        }
        if (this.isVarInstance() && !(this instanceof SortParameter)) {
            String varType = this.getVariableInstanceType();
            String alias = varType.toLowerCase() + this.objectCount;
            whereClause = whereClause + "process =" + alias + ".processInstance";
            whereClause = this.fieldName.endsWith("%") ? whereClause + " AND " + alias + ".name LIKE '" + this.fieldName + "'" : whereClause + " AND " + alias + ".name = '" + this.fieldName + "'";
            whereClause = this.ignoreCase ? whereClause + " AND lower(" + alias + ".value) " + this.getPredicate() : whereClause + " AND " + alias + ".value " + this.getPredicate();
            whereClause = whereClause + " AND " + alias + ".tokenVariableMap is not null";
        } else if (this.fieldName.equals("AccessLevel")) {
            whereClause = whereClause + this.alias + ".id " + this.getPredicate() + " AND " + this.alias + " in elements(" + WORKFLOW_TEMPLATE_ALIAS + ".protectionKeys) ";
        } else if (this.fieldName.equals("tokenstatus")) {
            whereClause = whereClause + "process.id = token" + this.objectCount + ".processInstance";
            whereClause = whereClause + " AND token" + this.objectCount + "." + "status" + this.getStatusPredicate();
        } else if (this.fieldName.equals("hidesubprocess")) {
            whereClause = whereClause + this.alias + ".superProcessToken is null";
        } else if (this.fieldName.equals("subprocess")) {
            whereClause = whereClause + this.alias + ".superProcessToken " + this.getPredicate();
        } else if (!(this instanceof SortParameter)) {
            whereClause = this.fieldName.equals("status".toString()) ? whereClause + "token." + this.fieldName + this.getStatusPredicate() : whereClause + "token." + this.fieldName + this.getPredicate();
        }
        return whereClause;
    }

    private String getStatusPredicate() {
        if (this instanceof RangeParameter) {
            throw new RuntimeException("Status cannot be searched using a RangeParameter");
        }
        if (this instanceof ListParameter) {
            ListParameter listParam = new ListParameter("status");
            for (Object obj : ((ListParameter)this).getValues()) {
                String status = obj.toString();
                listParam.setFieldType(SearchType.NUMERIC);
                if ("ACTIVE".equals(status)) {
                    listParam.addValue(0);
                    listParam.addValue(1);
                    listParam.addValue(7);
                    continue;
                }
                listParam.addValue(this.getOrdinal(status));
            }
            return listParam.getPredicate();
        }
        ListParameter listParam = new ListParameter("status");
        String status = ((ValueParameter)this).getValue().toString();
        listParam.setFieldType(SearchType.NUMERIC);
        if ("ACTIVE".equals(status)) {
            listParam.addValue(0);
            listParam.addValue(1);
            listParam.addValue(7);
        } else {
            listParam.addValue(this.getOrdinal(status));
        }
        return listParam.getPredicate();
    }

    private int getOrdinal(String status) {
        if ("CREATED".equalsIgnoreCase(status)) {
            return 0;
        }
        if ("RUNNING".equalsIgnoreCase(status)) {
            return 1;
        }
        if ("ERROR".equalsIgnoreCase(status)) {
            return 2;
        }
        if ("PAUSED".equalsIgnoreCase(status)) {
            return 3;
        }
        if ("QUEUED".equalsIgnoreCase(status)) {
            return 4;
        }
        if ("CANCELLED".equalsIgnoreCase(status)) {
            return 5;
        }
        if ("COMPLETED".equalsIgnoreCase(status)) {
            return 6;
        }
        if ("BUSY".equalsIgnoreCase(status)) {
            return 7;
        }
        if ("BRANCHED".equalsIgnoreCase(status)) {
            return 8;
        }
        if ("ARCHIVED".equalsIgnoreCase(status)) {
            return 9;
        }
        throw new IllegalArgumentException(status);
    }

    public abstract String getPredicate();

    public int hashCode() {
        return this.fieldName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchParameterBase other = (SearchParameterBase)obj;
        return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }
}

