/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service;

import com.tandbergtv.workflow.core.service.ServiceRegistry;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class ServiceLookup {
    private static final Logger LOGGER = Logger.getLogger(ServiceLookup.class);

    public static <T> T findService(final Class<T> clazz, long timeOutInMS, long retyInterval) {
        return ServiceLookup.forceExecute(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return ServiceRegistry.getDefault().lookup(clazz);
            }
        }, "Find service " + clazz.getSimpleName(), timeOutInMS, retyInterval);
    }

    public static <T> T forceExecute(Callable<T> fetcher, String operationName, long timeOutInMS, long retyInterval) {
        T result = null;
        Exception error = null;
        for (long count = 0L; count <= timeOutInMS; count += retyInterval) {
            try {
                result = fetcher.call();
            }
            catch (Exception e) {
                error = e;
            }
            if (result != null) break;
            try {
                LOGGER.info((Object)("Failed to " + operationName + ", sleep and retry it late. total waiting time:" + count + " ms."));
                Thread.sleep(retyInterval);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (result == null && error != null) {
            LOGGER.error((Object)("Failed to " + operationName), (Throwable)error);
        }
        return result;
    }
}

