/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.workflow.core.service.concurrent;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.tandbergtv.workflow.core.service.concurrent.AbstractRecoverableFutureWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

public class RecoverableMultiFutureWrapper<T>
extends AbstractRecoverableFutureWrapper<T, Collection<T>> {
    private static final Logger LOGGER = Logger.getLogger(RecoverableMultiFutureWrapper.class);
    private volatile Collection<Future<T>> futures;
    private AtomicInteger seq = new AtomicInteger(0);
    private AtomicReference<Collection<T>> result = new AtomicReference();
    private Lock lock = new ReentrantLock();

    private RecoverableMultiFutureWrapper() {
    }

    private void retry(Collection<Future<T>> futures) {
        this.futures = futures;
        this.start();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean isCancelled = false;
        for (Future<T> f : this.futures) {
            isCancelled |= f.cancel(mayInterruptIfRunning);
        }
        return isCancelled ? super.cancel(mayInterruptIfRunning) : false;
    }

    private void start() {
        this.result.set(new ArrayList(this.futures.size()));
        for (Future<T> f : this.futures) {
            ((ICompletableFuture)f).andThen(new IndexedCallback(this.seq.get(), this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResponse(int seq, T response) {
        if (seq < this.seq.get()) {
            LOGGER.debug((Object)("outdated callback received[" + response + "], skip"));
            return;
        }
        this.lock.lock();
        try {
            Collection<T> oldResult = this.result.get();
            oldResult.add(response);
            if (this.result.compareAndSet(oldResult, oldResult) && oldResult.size() == this.futures.size()) {
                LOGGER.debug((Object)(this.serviceName + " - Queue Size: " + this.queueSize.decrementAndGet()));
                this.set(oldResult);
                this.doCallback();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onFailure(int seq, Throwable t) {
        if (seq < this.seq.get()) {
            LOGGER.debug((Object)("outdated callback received[" + t + "], skip"));
            return;
        }
        if (!this.seq.compareAndSet(seq, seq + 1)) {
            return;
        }
        LOGGER.debug((Object)(this.serviceName + " - Queue Size: " + this.queueSize.decrementAndGet()));
        LOGGER.debug((Object)("Task: " + this.callable.toString() + " failed for " + (this.recoveryCount + 1) + "time(s)."), t);
        try {
            if (!this.shouldRecover(t) || this.recoveryCount >= this.maximumRetryAttempts) {
                if (this.recoveryCount >= this.maximumRetryAttempts) {
                    LOGGER.warn((Object)("Task: " + this.callable.toString() + " has exceeded " + this.maximumRetryAttempts + " attempts to recover, failing task."));
                }
                this.setException(t);
                this.doCallback();
                return;
            }
            String name = this.callable.toString();
            LOGGER.debug((Object)("Recovering task: " + name + ", rescheduling..."));
            this.recoveryScheduler.schedule(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    RecoverableMultiFutureWrapper.this.retry(RecoverableMultiFutureWrapper.this.executorService.submitToAllMembers(RecoverableMultiFutureWrapper.this.callable).values());
                    LOGGER.debug((Object)(RecoverableMultiFutureWrapper.this.serviceName + " - Queue Size: " + RecoverableMultiFutureWrapper.this.queueSize.incrementAndGet()));
                    ++RecoverableMultiFutureWrapper.this.recoveryCount;
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn((Object)"error when recovering task", (Throwable)e);
            this.setException(e);
            this.doCallback();
        }
    }

    public void setFutures(Collection<Future<T>> futures) {
        this.futures = futures;
    }

    public static class RecoverableMultiFutureBuilder<T>
    extends AbstractRecoverableFutureWrapper.Builder<RecoverableMultiFutureBuilder<T>, RecoverableMultiFutureWrapper<T>, T, Collection<T>> {
        public RecoverableMultiFutureBuilder<T> futures(Collection<Future<T>> futures) {
            ((RecoverableMultiFutureWrapper)this.wrapper).setFutures(futures);
            return this;
        }

        @Override
        public RecoverableMultiFutureWrapper<T> build() {
            Validate.notNull((Object)((RecoverableMultiFutureWrapper)this.wrapper).callable);
            Validate.notEmpty((Collection)((RecoverableMultiFutureWrapper)this.wrapper).futures);
            Validate.notNull((Object)((RecoverableMultiFutureWrapper)this.wrapper).executorService);
            Validate.notNull((Object)((RecoverableMultiFutureWrapper)this.wrapper).clusterService);
            Validate.notNull((Object)((RecoverableMultiFutureWrapper)this.wrapper).recoveryScheduler);
            Validate.notEmpty((String)((RecoverableMultiFutureWrapper)this.wrapper).serviceName);
            Validate.notNull((Object)((RecoverableMultiFutureWrapper)this.wrapper).queueSize);
            ((RecoverableMultiFutureWrapper)this.wrapper).start();
            return (RecoverableMultiFutureWrapper)this.wrapper;
        }

        @Override
        protected RecoverableMultiFutureWrapper<T> create() {
            return new RecoverableMultiFutureWrapper();
        }

        @Override
        protected RecoverableMultiFutureBuilder<T> getThis() {
            return this;
        }
    }

    private static class IndexedCallback<T1>
    implements ExecutionCallback<T1> {
        private final int seq;
        private final RecoverableMultiFutureWrapper<T1> future;

        private IndexedCallback(int seq, RecoverableMultiFutureWrapper<T1> future) {
            this.seq = seq;
            this.future = future;
        }

        public void onResponse(T1 response) {
            ((RecoverableMultiFutureWrapper)this.future).onResponse(this.seq, response);
        }

        public void onFailure(Throwable t) {
            ((RecoverableMultiFutureWrapper)this.future).onFailure(this.seq, t);
        }
    }
}

