/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management;

import java.util.ArrayList;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.management.Cache;
import net.sf.ehcache.management.CacheManagerMBean;

public class CacheManager
implements CacheManagerMBean {
    private net.sf.ehcache.CacheManager cacheManager;
    private ObjectName objectName;

    public CacheManager(net.sf.ehcache.CacheManager cacheManager) throws CacheException {
        this.cacheManager = cacheManager;
        this.objectName = CacheManager.createObjectName(cacheManager);
    }

    static ObjectName createObjectName(net.sf.ehcache.CacheManager cacheManager) {
        ObjectName objectName;
        try {
            objectName = new ObjectName("net.sf.ehcache:type=CacheManager,name=" + cacheManager.getName());
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException(e);
        }
        return objectName;
    }

    public String getStatus() {
        return this.cacheManager.getStatus().toString();
    }

    public void shutdown() {
        this.cacheManager.shutdown();
    }

    public void clearAll() {
        this.cacheManager.clearAll();
    }

    public Cache getCache(String name) {
        return new Cache(this.cacheManager.getCache(name));
    }

    public String[] getCacheNames() throws IllegalStateException {
        return this.cacheManager.getCacheNames();
    }

    public List getCaches() {
        ArrayList<Cache> cacheList = new ArrayList<Cache>();
        String[] caches = this.getCacheNames();
        for (int i = 0; i < caches.length; ++i) {
            String cacheName = caches[i];
            Cache cache = this.getCache(cacheName);
            cacheList.add(cache);
        }
        return cacheList;
    }

    ObjectName getObjectName() {
        return this.objectName;
    }
}

