/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.node.Node;

public class ServerLoggers {
    public static final Setting<Level> LOG_DEFAULT_LEVEL_SETTING = new Setting<Level>("logger.level", Level.INFO.name(), Level::valueOf, Setting.Property.NodeScope);
    public static final Setting.AffixSetting<Level> LOG_LEVEL_SETTING = Setting.prefixKeySetting("logger.", key -> new Setting<Level>((String)key, Level.INFO.name(), Level::valueOf, Setting.Property.Dynamic, Setting.Property.NodeScope));

    public static Logger getLogger(Class<?> clazz, Settings settings, ShardId shardId, String ... prefixes) {
        return ServerLoggers.getLogger(clazz, settings, shardId.getIndex(), CollectionUtils.asArrayList(Integer.toString(shardId.id()), prefixes).toArray(new String[0]));
    }

    public static Logger getLogger(String loggerName, Settings settings, ShardId shardId, String ... prefixes) {
        return ServerLoggers.getLogger(loggerName, settings, CollectionUtils.asArrayList(shardId.getIndexName(), Integer.toString(shardId.id()), prefixes).toArray(new String[0]));
    }

    public static Logger getLogger(Class<?> clazz, Settings settings, Index index, String ... prefixes) {
        return ServerLoggers.getLogger(clazz, settings, CollectionUtils.asArrayList(" ", index.getName(), prefixes).toArray(new String[0]));
    }

    public static Logger getLogger(Class<?> clazz, Settings settings, String ... prefixes) {
        List<String> prefixesList = ServerLoggers.prefixesList(settings, prefixes);
        return Loggers.getLogger(clazz, (String[])prefixesList.toArray(new String[prefixesList.size()]));
    }

    public static Logger getLogger(String loggerName, Settings settings, String ... prefixes) {
        List<String> prefixesList = ServerLoggers.prefixesList(settings, prefixes);
        return Loggers.getLogger((String)loggerName, (String[])prefixesList.toArray(new String[prefixesList.size()]));
    }

    private static List<String> prefixesList(Settings settings, String ... prefixes) {
        ArrayList<String> prefixesList = new ArrayList<String>();
        if (Node.NODE_NAME_SETTING.exists(settings)) {
            prefixesList.add(Node.NODE_NAME_SETTING.get(settings));
        }
        if (prefixes != null && prefixes.length > 0) {
            prefixesList.addAll(Arrays.asList(prefixes));
        }
        return prefixesList;
    }

    public static void setLevel(Logger logger, String level) {
        Level l = level == null ? null : Level.valueOf((String)level);
        ServerLoggers.setLevel(logger, l);
    }

    public static void setLevel(Logger logger, Level level) {
        LoggerContext ctx;
        if (!"".equals(logger.getName())) {
            Configurator.setLevel((String)logger.getName(), (Level)level);
        } else {
            ctx = LoggerContext.getContext((boolean)false);
            Configuration config = ctx.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
            loggerConfig.setLevel(level);
            ctx.updateLoggers();
        }
        ctx = LoggerContext.getContext((boolean)false);
        for (LoggerConfig loggerConfig : ctx.getConfiguration().getLoggers().values()) {
            if (!"".equals(logger.getName()) && !loggerConfig.getName().startsWith(logger.getName() + ".")) continue;
            Configurator.setLevel((String)loggerConfig.getName(), (Level)level);
        }
    }

    public static void addAppender(Logger logger, Appender appender) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        config.addAppender(appender);
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        if (!logger.getName().equals(loggerConfig.getName())) {
            loggerConfig = new LoggerConfig(logger.getName(), logger.getLevel(), true);
            config.addLogger(logger.getName(), loggerConfig);
        }
        loggerConfig.addAppender(appender, null, null);
        ctx.updateLoggers();
    }

    public static void removeAppender(Logger logger, Appender appender) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        if (!logger.getName().equals(loggerConfig.getName())) {
            loggerConfig = new LoggerConfig(logger.getName(), logger.getLevel(), true);
            config.addLogger(logger.getName(), loggerConfig);
        }
        loggerConfig.removeAppender(appender.getName());
        ctx.updateLoggers();
    }

    public static Appender findAppender(Logger logger, Class<? extends Appender> clazz) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        for (Map.Entry entry : loggerConfig.getAppenders().entrySet()) {
            if (!((Appender)entry.getValue()).getClass().equals(clazz)) continue;
            return (Appender)entry.getValue();
        }
        return null;
    }
}

