/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.elasticsearch.common.io.Channels;
import org.elasticsearch.index.translog.BaseTranslogReader;
import org.elasticsearch.index.translog.BufferedChecksumStreamInput;
import org.elasticsearch.index.translog.Checkpoint;
import org.elasticsearch.index.translog.Translog;

final class TranslogSnapshot
extends BaseTranslogReader {
    private final int totalOperations;
    private final Checkpoint checkpoint;
    protected final long length;
    private final ByteBuffer reusableBuffer;
    private long position;
    private int readOperations;
    private BufferedChecksumStreamInput reuse;

    TranslogSnapshot(BaseTranslogReader reader, long length) {
        super(reader.generation, reader.channel, reader.path, reader.firstOperationOffset);
        this.length = length;
        this.totalOperations = reader.totalOperations();
        this.checkpoint = reader.getCheckpoint();
        this.reusableBuffer = ByteBuffer.allocate(1024);
        this.readOperations = 0;
        this.position = this.firstOperationOffset;
        this.reuse = null;
    }

    @Override
    public int totalOperations() {
        return this.totalOperations;
    }

    @Override
    Checkpoint getCheckpoint() {
        return this.checkpoint;
    }

    public Translog.Operation next() throws IOException {
        if (this.readOperations < this.totalOperations) {
            return this.readOperation();
        }
        return null;
    }

    protected Translog.Operation readOperation() throws IOException {
        int opSize = this.readSize(this.reusableBuffer, this.position);
        this.reuse = this.checksummedStream(this.reusableBuffer, this.position, opSize, this.reuse);
        Translog.Operation op = this.read(this.reuse);
        this.position += (long)opSize;
        ++this.readOperations;
        return op;
    }

    @Override
    public long sizeInBytes() {
        return this.length;
    }

    @Override
    protected void readBytes(ByteBuffer buffer, long position) throws IOException {
        if (position >= this.length) {
            throw new EOFException("read requested past EOF. pos [" + position + "] end: [" + this.length + "], generation: [" + this.getGeneration() + "], path: [" + this.path + "]");
        }
        if (position < this.getFirstOperationOffset()) {
            throw new IOException("read requested before position of first ops. pos [" + position + "] first op on: [" + this.getFirstOperationOffset() + "], generation: [" + this.getGeneration() + "], path: [" + this.path + "]");
        }
        Channels.readFromFileChannelWithEofException(this.channel, position, buffer);
    }

    @Override
    public String toString() {
        return "TranslogSnapshot{readOperations=" + this.readOperations + ", position=" + this.position + ", estimateTotalOperations=" + this.totalOperations + ", length=" + this.length + ", generation=" + this.generation + ", reusableBuffer=" + this.reusableBuffer + '}';
    }
}

