/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.util;

public class RWLock {
    private int m_numWaitingReaders = 0;
    private int m_numWaitingWriters = 0;
    private int m_refCount = 0;

    public synchronized void acquireWrite() {
        while (this.m_refCount != 0) {
            ++this.m_numWaitingWriters;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --this.m_numWaitingWriters;
        }
        this.m_refCount = -1;
    }

    public synchronized void acquireRead() {
        while (this.m_refCount < 0 || this.m_numWaitingWriters > 0) {
            ++this.m_numWaitingReaders;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --this.m_numWaitingReaders;
        }
        ++this.m_refCount;
    }

    public synchronized void release() {
        if (this.m_refCount > 0) {
            --this.m_refCount;
        } else if (this.m_refCount == -1) {
            this.m_refCount = 0;
        } else {
            throw new RuntimeException("refCount should not be 0");
        }
        this.notifyAll();
    }
}

