/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.svc.Services;
import org.jbpm.util.ClassLoaderUtil;

public class JbpmConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    static ObjectFactory defaultObjectFactory = null;
    static Map instances = new HashMap();
    ObjectFactory objectFactory = null;
    private static Log log = LogFactory.getLog((Class)JbpmConfiguration.class);

    static void reset() {
        defaultObjectFactory = null;
        instances = new HashMap();
    }

    public JbpmConfiguration(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public static JbpmConfiguration getInstance() {
        return JbpmConfiguration.getInstance(null);
    }

    public static synchronized JbpmConfiguration getInstance(String resource) {
        JbpmConfiguration instance;
        if (resource == null) {
            resource = "jbpm.cfg.xml";
        }
        if ((instance = (JbpmConfiguration)instances.get(resource)) == null) {
            if (defaultObjectFactory != null) {
                log.debug((Object)("creating jbpm configuration from given default object factory '" + defaultObjectFactory + "'"));
                instance = new JbpmConfiguration(defaultObjectFactory);
            } else {
                try {
                    log.info((Object)("using jbpm configuration resource '" + resource + "'"));
                    InputStream jbpmCfgXmlStream = ClassLoaderUtil.getStream(resource);
                    ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(jbpmCfgXmlStream);
                    instance = new JbpmConfiguration(objectFactory);
                }
                catch (RuntimeException e) {
                    throw new JbpmException("couldn't parse jbpm configuration from resource '" + resource + "'", e);
                }
            }
            instances.put(resource, instance);
        }
        return instance;
    }

    protected static ObjectFactory parseObjectFactory(InputStream inputStream) {
        log.debug((Object)"loading defaults in jbpm configuration");
        ObjectFactoryParser objectFactoryParser = new ObjectFactoryParser();
        ObjectFactoryImpl objectFactoryImpl = new ObjectFactoryImpl();
        objectFactoryParser.parseElementsFromResource("org/jbpm/default.jbpm.cfg.xml", objectFactoryImpl);
        if (inputStream != null) {
            log.debug((Object)"loading specific configuration...");
            objectFactoryParser.parseElementsStream(inputStream, objectFactoryImpl);
        }
        return objectFactoryImpl;
    }

    public static JbpmConfiguration parseXmlString(String xml) {
        log.debug((Object)"creating jbpm configuration from xml string");
        ByteArrayInputStream inputStream = null;
        if (xml != null) {
            inputStream = new ByteArrayInputStream(xml.getBytes());
        }
        ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(inputStream);
        return new JbpmConfiguration(objectFactory);
    }

    public static JbpmConfiguration parseInputStream(InputStream inputStream) {
        ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(inputStream);
        log.debug((Object)"creating jbpm configuration from input stream");
        return new JbpmConfiguration(objectFactory);
    }

    public static JbpmConfiguration parseResource(String resource) {
        InputStream inputStream = null;
        log.debug((Object)("creating jbpm configuration from resource '" + resource + "'"));
        if (resource != null) {
            inputStream = ClassLoaderUtil.getStream(resource);
        }
        ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(inputStream);
        return new JbpmConfiguration(objectFactory);
    }

    public JbpmContext createJbpmContext() {
        return this.createJbpmContext("default.jbpm.context");
    }

    public JbpmContext createJbpmContext(String name) {
        JbpmContext jbpmContext = (JbpmContext)this.objectFactory.createObject(name);
        jbpmContext.jbpmConfiguration = this;
        return jbpmContext;
    }

    public ServiceFactory getServiceFactory(String serviceName) {
        return this.getServiceFactory(serviceName, "default.jbpm.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceFactory getServiceFactory(String serviceName, String jbpmContextName) {
        ServiceFactory serviceFactory = null;
        JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
        try {
            serviceFactory = jbpmContext.getServices().getServiceFactory(serviceName);
        }
        finally {
            jbpmContext.close();
        }
        return serviceFactory;
    }

    public void createSchema() {
        this.createSchema("default.jbpm.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(String jbpmContextName) {
        JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
        try {
            Services services = jbpmContext.getServices();
            DbPersistenceServiceFactory persistenceServiceFactory = (DbPersistenceServiceFactory)services.getServiceFactory("persistence");
            persistenceServiceFactory.createSchema();
        }
        finally {
            jbpmContext.close();
        }
    }

    public void dropSchema() {
        this.dropSchema("default.jbpm.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchema(String jbpmContextName) {
        JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
        try {
            Services services = jbpmContext.getServices();
            DbPersistenceServiceFactory persistenceServiceFactory = (DbPersistenceServiceFactory)services.getServiceFactory("persistence");
            persistenceServiceFactory.dropSchema();
        }
        finally {
            jbpmContext.close();
        }
    }

    public static abstract class Configs {
        public static ObjectFactory getObjectFactory() {
            ObjectFactory objectFactory = null;
            JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
            objectFactory = jbpmContext != null ? jbpmContext.objectFactory : JbpmConfiguration.getInstance().objectFactory;
            return objectFactory;
        }

        public static void setDefaultObjectFactory(ObjectFactory objectFactory) {
            defaultObjectFactory = objectFactory;
        }

        public static boolean hasObject(String name) {
            ObjectFactory objectFactory = Configs.getObjectFactory();
            return objectFactory.hasObject(name);
        }

        public static synchronized Object getObject(String name) {
            ObjectFactory objectFactory = Configs.getObjectFactory();
            return objectFactory.createObject(name);
        }

        public static String getString(String name) {
            return (String)Configs.getObject(name);
        }

        public static long getLong(String name) {
            return (Long)Configs.getObject(name);
        }

        public static int getInt(String name) {
            return (Integer)Configs.getObject(name);
        }

        public static boolean getBoolean(String name) {
            return (Boolean)Configs.getObject(name);
        }
    }
}

