/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager;

import com.tandbergtv.metadatamanager.IDocumentDAO;
import com.tandbergtv.metadatamanager.MetadataManagerDAOImpl;
import com.tandbergtv.metadatamanager.MetadataWorkerFactory;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.RootAssetRevision;
import com.tandbergtv.metadatamanager.oracle.GetMetadata;
import com.tandbergtv.metadatamanager.oracle.OriginalCheckQuery;
import com.tandbergtv.metadatamanager.search.MDMTable;
import com.tandbergtv.metadatamanager.specimpl.SchemaValidator;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.Utils;
import com.tandbergtv.metadatamanager.util.binder.ECMFBinder;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.query.NativeQuery;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Document;

public class DocumentDAO
implements IDocumentDAO {
    static final Logger logger = Logger.getLogger(MetadataManagerDAOImpl.class);
    private HibernateTemplate template;
    private MetadataWorkerFactory metadataWorkerFactory;

    public void setMetadataWorkerFactory(MetadataWorkerFactory factory) {
        this.metadataWorkerFactory = factory;
    }

    public void setTemplate(HibernateTemplate template) {
        this.template = template;
    }

    @Override
    @Transactional
    public Asset saveAsset(Asset asset) throws MetadataException {
        boolean isNewRevision = true;
        Session session = this.getCurrentSession();
        Group rootAsset = (Group)asset;
        int revision = rootAsset.getLatestRevisionNumber();
        RootAssetRevision newRootAssetRevision = rootAsset.getRevision(revision);
        List<RootAssetRevision> revisions = this.getRootAssetRevisions(session, rootAsset.getTTVId(), revision);
        if (revisions != null && !revisions.isEmpty()) {
            isNewRevision = false;
        }
        boolean newAsset = !rootAsset.getTTVId().isValidIdentifier();
        List<Asset> assets = rootAsset.getAllAssets(true);
        List<Object> newAssetList = new ArrayList();
        if (newAsset) {
            newAssetList = assets;
        } else {
            for (Asset a : assets) {
                if (a.getId() >= 1L) continue;
                newAssetList.add(a);
            }
        }
        if (!newAssetList.isEmpty()) {
            try {
                session.doWork(this.metadataWorkerFactory.createAssetIdGenWorker(newAssetList));
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw new MetadataException(ex.getMessage(), ex);
            }
        }
        if (newAsset) {
            newRootAssetRevision.setDocumentId(rootAsset.getId());
        }
        logger.debug((Object)("Saving asset tree, new revision: " + isNewRevision));
        ArrayList<Asset> assetList = new ArrayList<Asset>();
        assetList.add(rootAsset);
        Document ecmfDoc = new ECMFBinder().bind(assetList);
        boolean isOriginal = true;
        if (rootAsset.getOriginalAssetID() != null) {
            isOriginal = false;
        } else {
            SchemaValidator.getInstance().validate(ecmfDoc);
        }
        Work work = newAsset ? this.metadataWorkerFactory.createInsertMetadataWorker(isOriginal, ecmfDoc) : this.metadataWorkerFactory.createUpdateMetadataWorker(rootAsset.getId(), ecmfDoc, isNewRevision, isOriginal);
        try {
            session.doWork(work);
        }
        catch (Exception ex) {
            logger.error((Object)Utils.serialize(ecmfDoc));
            throw new MetadataException(ex.getMessage(), ex);
        }
        session.merge((Object)newRootAssetRevision);
        return rootAsset;
    }

    @Override
    @Transactional
    public void deleteAsset(Asset asset) throws MetadataException {
        Session session = this.getCurrentSession();
        this.inactivateAllChildren(asset);
        Group rootAsset = (Group)asset;
        int revision = rootAsset.getLatestRevisionNumber();
        RootAssetRevision newRootAssetRevision = rootAsset.getRevision(revision);
        boolean isOriginal = true;
        if (rootAsset.getOriginalAssetID() != null) {
            isOriginal = false;
        }
        Work work = this.metadataWorkerFactory.createDeleteMetadataWorker(isOriginal, rootAsset.getTTVId().getId());
        try {
            session.doWork(work);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new MetadataException(ex.getMessage(), ex);
        }
        session.merge((Object)newRootAssetRevision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public Asset getAsset(TTVId identifier, int revisionNumber, boolean withCurrentSession) throws SearchException, InvalidRevisionException {
        Session session = this.getCurrentSession();
        boolean withNewSession = false;
        if (!withCurrentSession || !session.isOpen()) {
            session = this.getNewSession();
            withNewSession = true;
        }
        if (revisionNumber == 0) {
            revisionNumber = Integer.MAX_VALUE;
        }
        List<RootAssetRevision> allRevisions = null;
        allRevisions = this.getRootAssetRevisions(session, identifier, 0);
        if (allRevisions.isEmpty()) {
            String msg = "No RootAssetRevisions found for document with id=" + identifier.getId();
            logger.info((Object)msg);
            throw new SearchException(msg);
        }
        boolean isGettingLatest = revisionNumber >= allRevisions.get(0).getRevisionNumber();
        Asset asset = null;
        try {
            MDMTable mdmType = this.getMdmType(isGettingLatest, identifier, session);
            asset = this.getAsset(mdmType, identifier, isGettingLatest, revisionNumber, allRevisions, session);
            if (asset == null && isGettingLatest && (asset = this.getAsset(MDMTable.REVISION, identifier, false, revisionNumber = allRevisions.get(0).getRevisionNumber(), allRevisions, session)) != null) {
                this.inactivateAllChildren(asset);
            }
            if (asset == null) {
                String msg = "No document found with id=" + identifier.getId();
                if (!isGettingLatest) {
                    msg = msg + " and revision=" + revisionNumber;
                }
                logger.info((Object)msg);
                throw new SearchException(msg);
            }
        }
        finally {
            if (withNewSession) {
                logger.info((Object)"Close the new session");
                session.close();
            }
        }
        return asset;
    }

    private void inactivateAllChildren(Asset a) {
        a.setState(false);
        for (Relation relation : a.getRelations()) {
            Asset targetAsset = relation.getTargetAsset();
            targetAsset.setState(false);
            this.inactivateAllChildren(targetAsset);
        }
    }

    private MDMTable getMdmType(boolean isGettingLatest, TTVId identifier, Session session) throws SearchException {
        MDMTable mdmType;
        if (isGettingLatest) {
            OriginalCheckQuery work = this.metadataWorkerFactory.createOrinalCheckQueryWorker(identifier.getId());
            try {
                session.doWork((Work)work);
                if (work.getOriginalTitleId() == null) {
                    mdmType = MDMTable.MASTER;
                }
                mdmType = MDMTable.COPY;
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw new SearchException(ex.getMessage());
            }
        } else {
            mdmType = MDMTable.REVISION;
        }
        return mdmType;
    }

    private Asset getAsset(MDMTable mdmType, TTVId identifier, boolean isGettingLatest, int revisionNumber, List<RootAssetRevision> allRevisions, Session session) throws SearchException, InvalidRevisionException {
        GetMetadata work = this.metadataWorkerFactory.createGetMetadataWorker(mdmType, identifier.getId(), revisionNumber);
        List<Document> ecmfDocs = null;
        try {
            session.doWork((Work)work);
            ecmfDocs = work.getDocuments();
            if (ecmfDocs.size() > 1) {
                String msg = "More than one document found with id=" + identifier.getId();
                if (!isGettingLatest) {
                    msg = msg + " and revision=" + revisionNumber;
                }
                logger.info((Object)msg);
                throw new SearchException(msg);
            }
            if (ecmfDocs.isEmpty()) {
                return null;
            }
        }
        catch (HibernateException e) {
            logger.error((Object)e);
            throw new SearchException(e.getMessage());
        }
        List<Asset> pkgs = new ECMFBinder().bind(ecmfDocs.get(0));
        Group rootAsset = (Group)pkgs.get(0);
        rootAsset.setRevisions(allRevisions);
        return rootAsset;
    }

    private Session getNewSession() {
        return this.template.getSessionFactory().openSession();
    }

    private Session getCurrentSession() {
        return (Session)this.template.executeWithNativeSession(new HibernateCallback(){

            public Session doInHibernate(Session session) {
                return session;
            }
        });
    }

    private List<RootAssetRevision> getRootAssetRevisions(Session session, TTVId id, int revision) {
        StringBuilder b = new StringBuilder("select * from MDM_ROOTASSETREVISION where asset_id=");
        b.append(id.getId());
        if (revision > 0) {
            b.append(" and revisionnumber=" + revision);
        } else {
            b.append(" order by revisionnumber desc");
        }
        NativeQuery q = session.createSQLQuery(b.toString()).addEntity(RootAssetRevision.class);
        return q.list();
    }

    @Override
    public List<Document> getDocuments(String sql) {
        GetMetadata work = this.metadataWorkerFactory.createGetMetadataWorker(sql);
        this.getCurrentSession().doWork((Work)work);
        return work.getDocuments();
    }
}

