/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager;

import com.tandbergtv.metadatamanager.CVEMessageExtractor;
import com.tandbergtv.metadatamanager.IDocumentDAO;
import com.tandbergtv.metadatamanager.MetadataManagerDAO;
import com.tandbergtv.metadatamanager.assetkey.AssetKeyHandler;
import com.tandbergtv.metadatamanager.assetkey.IdDAO;
import com.tandbergtv.metadatamanager.assetkey.PgFieldAllIndexInfo;
import com.tandbergtv.metadatamanager.customfield.model.CustomField;
import com.tandbergtv.metadatamanager.customfield.model.CustomFieldGroup;
import com.tandbergtv.metadatamanager.customfield.persistence.CustomFieldPersistenceService;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.factoryImpl.IdentifierFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.AssetState;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.jdbc.Work;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class MetadataManagerDAOImpl
implements MetadataManagerDAO {
    private static final Logger logger = Logger.getLogger(MetadataManagerDAOImpl.class);
    private HibernateTemplate template;
    private PlatformTransactionManager platformTxMgr;
    private String tablePrefix;
    private AssetSearchService assetSearchService;
    private IDocumentDAO documentDAO;
    private IdDAO assetIdDAO;

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public PlatformTransactionManager getPlatformTxMgr() {
        return this.platformTxMgr;
    }

    public void setPlatformTxMgr(PlatformTransactionManager platformTxMgr) {
        this.platformTxMgr = platformTxMgr;
    }

    public HibernateTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(HibernateTemplate template) {
        this.template = template;
    }

    public void setAssetIdDAO(IdDAO assetIdDAO) {
        this.assetIdDAO = assetIdDAO;
    }

    public void setDocumentDAO(IDocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    @Override
    @Transactional
    public Asset saveAsset(Asset asset) throws MetadataException {
        logger.debug((Object)"Start of saveAsset()");
        try {
            if (asset.getState() == AssetState.INACTIVE) {
                throw new MetadataException("Cannot add inactive assets to the store.");
            }
            asset = AssetUtil.deleteEmptyFields(asset);
            Asset savedAsset = this.documentDAO.saveAsset(asset);
            AssetKeyHandler akHandler = new AssetKeyHandler(this.assetIdDAO);
            akHandler.updateAssetKeys(asset);
            this.getTemplate().flush();
            return savedAsset;
        }
        catch (DataAccessException e) {
            throw new MetadataException(e.getMessage(), e);
        }
        catch (ConstraintViolationException cve) {
            SQLException sqle = cve.getSQLException().getNextException();
            String errorMsg = sqle.getMessage();
            if (errorMsg.contains(IdDAO.assetKeyTableUniqueIndexName)) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("Asset[");
                sb.append(asset.getTTVId().isValidIdentifier() ? Long.valueOf(asset.getId()) : asset.getAssetType());
                sb.append("] has key(s) which is/are not unique in the system. ");
                sb.append(CVEMessageExtractor.getDuplicateKeyAndValueMessage(errorMsg));
                throw new MetadataException(sb.toString(), cve);
            }
            throw new MetadataException(cve.getMessage(), cve);
        }
    }

    @Override
    @Transactional
    public void delete(Asset a) throws SearchException {
        try {
            a = this.getAssetFromCurrentSession(new TTVId(a.getId()), 0);
            if (a.getRoot() != null) {
                String msg = "Non-root asset cannot be deleted from database";
                logger.debug((Object)msg);
                throw new SearchException(msg);
            }
            AssetKeyHandler akHandler = new AssetKeyHandler(this.assetIdDAO);
            akHandler.removeAssetKeys(a);
            this.documentDAO.deleteAsset(a);
            this.getTemplate().flush();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new SearchException(e.getMessage());
        }
    }

    @Override
    @Transactional
    public Asset getAssetFromCurrentSession(TTVId id, int revisionNumber) throws SearchException, InvalidRevisionException {
        return this.getAsset(id, revisionNumber, true);
    }

    @Override
    @Transactional
    public Asset getAsset(TTVId id, int revisionNumber) throws SearchException, InvalidRevisionException {
        return this.getAsset(id, revisionNumber, true);
    }

    @Override
    @Transactional
    public Asset getDeletedAsset(TTVId id) throws SearchException {
        try {
            return this.getAsset(id, 0, false);
        }
        catch (InvalidRevisionException e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Transactional
    private Asset getAsset(TTVId id, int revisionNumber, boolean withCurrentSession) throws SearchException, InvalidRevisionException {
        return this.documentDAO.getAsset(id, revisionNumber, withCurrentSession);
    }

    @Override
    @Transactional
    public Asset getAsset(TTVId id) throws SearchException {
        try {
            return this.getAsset(id, 0);
        }
        catch (InvalidRevisionException e) {
            logger.error((Object)("Unable to get latest Asset with TTVid: " + id), (Throwable)e);
            throw new SearchException("Invalid Revision");
        }
    }

    public AssetSearchService getAssetSearchService() {
        return this.assetSearchService;
    }

    public void setAssetSearchService(AssetSearchService assetSearchService) {
        this.assetSearchService = assetSearchService;
    }

    @Override
    @Transactional
    public Collection<TTVId> getAssetCopyIds(TTVId id) {
        logger.info((Object)".........Asset.GetCopyIDs query not supported yet!!!!!!!!!");
        ArrayList results = new ArrayList();
        ArrayList<TTVId> copyIDs = new ArrayList<TTVId>();
        for (Object assetID : results) {
            TTVId ttvId = IdentifierFactory.getTTVIdentifier((Long)assetID);
            copyIDs.add(ttvId);
        }
        return copyIDs;
    }

    @Override
    @Transactional
    public TTVId getOriginalAssetId(TTVId copiedAssetId) {
        logger.info((Object)".........Asset.GetOriginalID query not supported yet!!!!!!");
        ArrayList results = new ArrayList();
        TTVId originalId = null;
        if (!results.isEmpty()) {
            originalId = IdentifierFactory.getTTVIdentifier((Long)results.get(0));
        }
        return originalId;
    }

    @Override
    @Transactional
    public Map<String, List<String>> getAllCustomFieldNames() {
        HashMap<String, List<String>> cfs = new HashMap<String, List<String>>();
        CustomFieldPersistenceService cfDao = new CustomFieldPersistenceService();
        cfDao.setTemplate(this.getTemplate());
        List<CustomFieldGroup> grps = cfDao.getAllGroups();
        for (CustomFieldGroup g : grps) {
            String assetPath = g.getAssetPath();
            ArrayList<String> names = (ArrayList<String>)cfs.get(assetPath);
            if (names == null) {
                names = new ArrayList<String>();
            }
            List<CustomField> cflds = g.getCustomFieldList();
            for (CustomField cfld : cflds) {
                names.add(cfld.getName());
            }
            cfs.put(assetPath, names);
            if (assetPath.startsWith("PACKAGE/")) {
                cfs.put(assetPath.replace("PACKAGE/", "SERIES/"), names);
            }
            if (assetPath.startsWith("PACKAGE/POSTER")) {
                cfs.put(assetPath.replace("PACKAGE/POSTER", "SERIES/SEASON/POSTER"), names);
            }
            if (!assetPath.startsWith("PACKAGE/BOXCOVER")) continue;
            cfs.put(assetPath.replace("PACKAGE/BOXCOVER", "SERIES/SEASON/BOXCOVER"), names);
        }
        return cfs;
    }

    @Override
    @Transactional
    public void validateAssetKeys(Asset asset) throws MetadataException {
        AssetKeyHandler akHandler = new AssetKeyHandler(this.assetIdDAO);
        akHandler.validateForPersistence(asset);
    }

    @Override
    public Session getCurrentSession() {
        return (Session)this.getTemplate().executeWithNativeSession(new HibernateCallback(){

            public Session doInHibernate(Session session) {
                return session;
            }
        });
    }

    @Override
    @Transactional
    public Map<String, Map<String, List<String>>> getAllIndexFields() throws MetadataException {
        PgFieldAllIndexInfo work = new PgFieldAllIndexInfo();
        try {
            this.template.getSessionFactory().openSession().doWork((Work)work);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new MetadataException(ex.getMessage());
        }
        return work.getAllIndexFieldsMap();
    }

    @Override
    @Transactional
    public String createUniqueIndex(String specAlias, Collection<String> ttvPaths) {
        return this.assetIdDAO.createUniqueIndex(specAlias, ttvPaths);
    }

    @Override
    @Transactional
    public void dropIndexes(Set<String> indexNames) {
        this.assetIdDAO.deleteIndexes(indexNames);
    }
}

