/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager;

import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.oracle.AssetIdGen;
import com.tandbergtv.metadatamanager.oracle.DeleteMetadata;
import com.tandbergtv.metadatamanager.oracle.GetMetadata;
import com.tandbergtv.metadatamanager.oracle.InsertMetadata;
import com.tandbergtv.metadatamanager.oracle.OriginalCheckQuery;
import com.tandbergtv.metadatamanager.oracle.UpdateMetadata;
import com.tandbergtv.metadatamanager.pg.PgDeleteMetadata;
import com.tandbergtv.metadatamanager.pg.PgGetMetadata;
import com.tandbergtv.metadatamanager.pg.PgInsertMetadata;
import com.tandbergtv.metadatamanager.pg.PgUpdateMetadata;
import com.tandbergtv.metadatamanager.search.MDMTable;
import java.util.List;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.jdbc.Work;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.w3c.dom.Document;

public class MetadataWorkerFactory {
    private HibernateTemplate template;

    public void setHibernateTemplate(HibernateTemplate template) {
        this.template = template;
    }

    private boolean isOracle() {
        return ((SessionFactoryImpl)this.template.getSessionFactory()).getDialect().getClass().getName().contains("Oracle");
    }

    public Work createInsertMetadataWorker(boolean isRevisionTable, Document ecmfDoc) throws MetadataException {
        if (this.isOracle()) {
            return new InsertMetadata(isRevisionTable, ecmfDoc);
        }
        return new PgInsertMetadata(isRevisionTable, ecmfDoc);
    }

    public Work createUpdateMetadataWorker(long documentId, Document ecmfDoc, boolean isNewRevision, boolean isOriginal) throws MetadataException {
        if (this.isOracle()) {
            return new UpdateMetadata(documentId, ecmfDoc, isNewRevision, isOriginal);
        }
        return new PgUpdateMetadata(documentId, ecmfDoc, isNewRevision, isOriginal);
    }

    public Work createDeleteMetadataWorker(boolean isOriginal, long documentId) {
        if (this.isOracle()) {
            return new DeleteMetadata(isOriginal, documentId);
        }
        return new PgDeleteMetadata(isOriginal, documentId);
    }

    public Work createAssetIdGenWorker(List<Asset> newAssets) {
        return new AssetIdGen(newAssets);
    }

    public GetMetadata createGetMetadataWorker(MDMTable mdmType, long documentId, int revision) {
        if (this.isOracle()) {
            return new GetMetadata(mdmType, documentId, revision);
        }
        return new PgGetMetadata(mdmType, documentId, revision);
    }

    public GetMetadata createGetMetadataWorker(String sql) {
        if (this.isOracle()) {
            return new GetMetadata(sql);
        }
        return new PgGetMetadata(sql);
    }

    public OriginalCheckQuery createOrinalCheckQueryWorker(long documentId) {
        return new OriginalCheckQuery(documentId);
    }
}

