/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.assetkey;

import com.ericsson.cms.criteria.ExpList;
import com.tandbergtv.metadatamanager.assetkey.AssetKeyManager;
import com.tandbergtv.metadatamanager.assetkey.IdDAO;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.SearchFieldBuilder;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.specimpl.ValidatorHelper;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.binder.ECMFFieldJsonBinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class AssetKeyHandler {
    IdDAO dao;
    static final Logger logger = Logger.getLogger(AssetKeyHandler.class);

    public AssetKeyHandler(IdDAO dao) {
        this.dao = dao;
    }

    public void validateForPersistence(Asset rootAsset) throws MetadataException {
        if (rootAsset.getOriginalAssetID() != null) {
            return;
        }
        List<Asset> assets = AssetKeyHandler.getAssetsInTree(rootAsset);
        for (Asset currentAsset : assets) {
            this.doValidateForPersistence(currentAsset);
        }
    }

    public void updateAssetKeys(Asset rootAsset) throws MetadataException {
        if (rootAsset.getOriginalAssetID() != null) {
            return;
        }
        Long rootAssetId = rootAsset.getId();
        if (rootAssetId != null && rootAssetId > 0L) {
            this.dao.deleteKeys(rootAssetId);
        }
        Map<Asset, String> data = AssetKeyHandler.getDataForUpdate(rootAsset);
        this.dao.saveKeys(data);
    }

    public void removeAssetKeys(Asset rootAsset) throws MetadataException {
        if (rootAsset.getOriginalAssetID() != null) {
            return;
        }
        Long rootAssetId = rootAsset.getId();
        if (rootAssetId != null && rootAssetId > 0L) {
            this.dao.deleteKeys(rootAssetId);
        }
    }

    public Collection<Long> searchForDocId(SearchCriteria specKeyMap) {
        SearchCriteria indexedKeyFields = this.convertToIndexedFields(specKeyMap);
        return this.dao.getDocumentId(indexedKeyFields);
    }

    public List<Document> searchForFullDoc(SearchCriteria specKeyMap) {
        SearchCriteria indexedKeyFields = this.convertToIndexedFields(specKeyMap);
        return this.dao.getDocuments(indexedKeyFields);
    }

    public static Map<Asset, String> getDataForUpdate(Asset rootAsset) throws MetadataException {
        List<Asset> assets = AssetKeyHandler.getAssetsInTree(rootAsset);
        ECMFFieldJsonBinder jsonHelper = new ECMFFieldJsonBinder();
        HashMap<Asset, String> data = new HashMap<Asset, String>();
        for (Asset asset : assets) {
            Set<Field> keyFields = AssetKeyHandler.getKeyFields(asset);
            if (!keyFields.isEmpty()) {
                String json = jsonHelper.convert(new ArrayList<Field>(keyFields));
                logger.debug((Object)(" assetId=" + asset.getId() + " json=" + json));
                data.put(asset, json);
                continue;
            }
            logger.debug((Object)(" No key fields for asset : " + asset.toString()));
        }
        return data;
    }

    private static List<Asset> getAssetsInTree(Asset asset) {
        ArrayList<Asset> assets = new ArrayList<Asset>();
        AssetKeyHandler.getAssetsInTree(asset, assets);
        return assets;
    }

    private static void getAssetsInTree(Asset asset, List<Asset> assets) {
        assets.add(asset);
        int currentIndex = 0;
        while (currentIndex < assets.size()) {
            Asset currentAsset;
            if ((currentAsset = assets.get(currentIndex++)).getRelations() == null) continue;
            for (Relation relation : currentAsset.getRelations()) {
                Asset target = relation.getTargetAsset();
                if (assets.contains(target)) continue;
                assets.add(target);
            }
        }
    }

    private static Collection<ISpecHandler> getSpecificationHandlersForValidation() {
        ValidatorHelper helper = ValidatorHelper.getInstance();
        return helper.getSpecificationHandlersForValidation();
    }

    private static SearchCriteria getAssetSpecificationKey(Asset asset, ISpecHandler handler) {
        IIdentifier identifier = handler.extractId(asset);
        if (!identifier.isValidIdentifier()) {
            return null;
        }
        Map<String, String> idPaths = identifier.getTTVPaths();
        Map<String, String> identifiers = identifier.getSpecIdentifiers();
        SearchCriteria criteria = new SearchCriteria();
        for (String specificationIDXPath : idPaths.keySet()) {
            String ttvIDXPath = idPaths.get(specificationIDXPath);
            String value = identifiers.get(specificationIDXPath);
            if (AssetSearchKey.ASSET_ID.toString().equals(ttvIDXPath)) {
                return null;
            }
            if (value != null && value.equals("")) {
                value = null;
            }
            criteria.put(ttvIDXPath, value);
        }
        return criteria;
    }

    private SearchCriteria convertToIndexedFields(SearchCriteria criteria) {
        SearchCriteria newCriteria = new SearchCriteria();
        Set xpaths = criteria.keySet();
        for (String xpath : xpaths) {
            String column = AssetKeyManager.getInstance().getIndexedFieldName(xpath);
            newCriteria.put(column, criteria.get(xpath));
        }
        return newCriteria;
    }

    private void doValidateForPersistence(Asset asset) throws MetadataException {
        Asset root = asset.getRoot() != null ? asset.getRoot() : asset;
        TTVId rootId = root.getTTVId();
        Long docId = null;
        if (rootId.isValidIdentifier()) {
            docId = rootId.getId();
        }
        if (!asset.getSpecKeyValuesHasChanged()) {
            return;
        }
        Long assetId = asset.getId();
        Collection<ISpecHandler> handlers = docId == null || assetId == null || assetId < 1L ? AssetKeyHandler.getSpecificationHandlersForValidation() : asset.getSpecHandlersForValidation();
        if (handlers == null || handlers.isEmpty()) {
            return;
        }
        StringBuilder searchAssetSpecKeys = new StringBuilder();
        for (ISpecHandler handler : handlers) {
            ExpList searchFields;
            SearchCriteria indexedKeyFields;
            SearchCriteria assetKey = AssetKeyHandler.getAssetSpecificationKey(asset, handler);
            if (assetKey == null || (indexedKeyFields = this.convertToIndexedFields(assetKey)) == null || indexedKeyFields.isEmptyCriteria() || (searchFields = new SearchFieldBuilder().getAssetSearchFields(indexedKeyFields, false)) == null || searchFields.isEmpty()) continue;
            searchAssetSpecKeys.append(handler.getSpecName() + ".assetKey=" + assetKey.toString() + ":");
            boolean conflictsExist = this.dao.checkKeys(indexedKeyFields);
            if (!conflictsExist) continue;
            String assetName = "Asset[";
            assetName = assetName + (asset.getTTVId().isValidIdentifier() ? Long.valueOf(asset.getId()) : asset.getAssetType());
            assetName = assetName + "]";
            String msg = assetName + " has key(s) which is/are not unique in the system. ";
            msg = msg + searchAssetSpecKeys.toString();
            throw new MetadataException(msg);
        }
    }

    public static Set<Field> getKeyFields(Asset asset) throws MetadataException {
        HashSet<Field> keyFields = new HashSet<Field>();
        Collection<ISpecHandler> handlers = AssetKeyHandler.getSpecificationHandlersForValidation();
        for (ISpecHandler handler : handlers) {
            SearchCriteria assetKey = AssetKeyHandler.getAssetSpecificationKey(asset, handler);
            if (assetKey == null) continue;
            Set xpaths = assetKey.keySet();
            for (String xpath : xpaths) {
                Field fld = asset.getFirstField(xpath);
                keyFields.add(fld);
            }
        }
        return keyFields;
    }
}

