/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.assetkey;

import com.tandbergtv.metadatamanager.assetkey.IdDAO;
import com.tandbergtv.metadatamanager.assetkey.IndexInfoUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.jdbc.Work;

public class PgFieldAllIndexInfo
implements Work {
    private static final String TABLE_IS_NOT_UNIQUE = "NON_UNIQUE";
    public static String UNIQUE_INDEX = "unique";
    private static final String NON_UNIQUE_INDEX = "non_unique";
    private static final String TABLE_INDEX_NAME = "INDEX_NAME";
    private static final String TABLE_COLUMN_NAME = "COLUMN_NAME";
    static Map<String, Map<String, List<String>>> allIndexFieldsMap = new HashMap<String, Map<String, List<String>>>();
    static Map<String, List<String>> uniqueIndexFieldMap = new HashMap<String, List<String>>();
    static Map<String, List<String>> nonUniqueIndexFieldMap = new HashMap<String, List<String>>();

    public void execute(Connection connection) throws SQLException {
        PgFieldAllIndexInfo.getAllIndexes(connection);
    }

    public static Map<String, Map<String, List<String>>> getAllIndexes(Connection connection) throws SQLException {
        DatabaseMetaData dbmd = connection.getMetaData();
        ResultSet indexList = dbmd.getIndexInfo(null, null, IdDAO.assetKeyTable, false, false);
        PgFieldAllIndexInfo.clearTheMaps();
        while (indexList.next()) {
            String indexAlias = indexList.getString(TABLE_INDEX_NAME);
            String indexFieldName = indexList.getString(TABLE_COLUMN_NAME);
            if (indexFieldName.equalsIgnoreCase(IdDAO.documentIdColumn) || indexFieldName.equalsIgnoreCase(IdDAO.assetIdColumn)) continue;
            boolean isUniqueIndex = !indexList.getBoolean(TABLE_IS_NOT_UNIQUE);
            PgFieldAllIndexInfo.addIntoMap(isUniqueIndex ? uniqueIndexFieldMap : nonUniqueIndexFieldMap, indexAlias, indexFieldName);
        }
        allIndexFieldsMap.put(UNIQUE_INDEX, uniqueIndexFieldMap);
        allIndexFieldsMap.put(NON_UNIQUE_INDEX, nonUniqueIndexFieldMap);
        return allIndexFieldsMap;
    }

    private static void clearTheMaps() {
        uniqueIndexFieldMap.clear();
        nonUniqueIndexFieldMap.clear();
        allIndexFieldsMap.clear();
    }

    private static void addIntoMap(Map<String, List<String>> fieldMap, String indexAlias, String indexFieldName) {
        if (!fieldMap.containsKey(indexAlias)) {
            ArrayList fieldsList = new ArrayList();
            fieldMap.put(indexAlias, fieldsList);
        }
        String xpath = IndexInfoUtil.getXpathFromIndexFieldName(indexFieldName);
        fieldMap.get(indexAlias).add(xpath);
    }

    public Map<String, Map<String, List<String>>> getAllIndexFieldsMap() {
        return allIndexFieldsMap;
    }
}

