/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.conf;

import com.tandbergtv.metadatamanager.MetadataManagerDAO;
import com.tandbergtv.metadatamanager.RuleManagerDAO;
import com.tandbergtv.metadatamanager.factoryImpl.SpecHandlerFactory;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import com.tandbergtv.metadatamanager.spec.ITranslator;
import com.tandbergtv.metadatamanager.spec.IValidator;
import com.tandbergtv.metadatamanager.specimpl.RuleManagerBase;
import com.tandbergtv.metadatamanager.util.MappingFileParser;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class SpecificationBuilder {
    private static final Logger logger = Logger.getLogger(SpecificationBuilder.class);
    private static final String PLUGIN_ID = "com.tandbergtv.metadata";
    private static final String EXTENSION_POINT_ID = "specification";
    private PluginManager pluginManager = null;
    protected MetadataManagerDAO metadataManagerDAO;
    protected RuleManagerDAO ruleManagerDAO;
    protected ISpecHandler specHandler;
    protected Map<String, ISpecHandler> specHandlerMap;
    protected Map<String, URL> identifierMappingResourceMap;
    private ApplicationContext context;

    public SpecificationBuilder(PluginManager pluginManager, ApplicationContext context) {
        this.pluginManager = pluginManager;
        this.context = context;
        this.specHandlerMap = new HashMap<String, ISpecHandler>();
        this.identifierMappingResourceMap = new HashMap<String, URL>();
        this.metadataManagerDAO = (MetadataManagerDAO)context.getBean("metadataManagerDAOImpl");
        this.ruleManagerDAO = (RuleManagerDAO)context.getBean("ruleManagerDAOImpl");
    }

    public void buildSpecifications() {
        logger.info((Object)"Building Specifications");
        PluginRegistry pluginRegistry = this.pluginManager.getRegistry();
        ExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
        Collection extensions = point.getAvailableExtensions();
        for (Extension extension : extensions) {
            String defaultRuleSetFilePath;
            String validatorFilePath;
            String specSpecificTTVXpathsFileName;
            String mappingResource;
            PluginDescriptor descriptor = extension.getDeclaringPluginDescriptor();
            PluginClassLoader classLoader = this.pluginManager.getPluginClassLoader(descriptor);
            String alias = extension.getParameter("alias").valueAsString();
            if (StringUtils.isEmpty((String)alias)) {
                throw new RuntimeException("Alias Not Specified!");
            }
            String contextFile = extension.getParameter("spechandler").valueAsString();
            URL url1 = classLoader.getResource(contextFile);
            String path = url1.getPath();
            path = "file:" + path;
            try (FileSystemXmlApplicationContext jpfContext = new FileSystemXmlApplicationContext(this.context);){
                jpfContext.setConfigLocation(path);
                jpfContext.setClassLoader((ClassLoader)classLoader);
                jpfContext.refresh();
                this.specHandler = (ISpecHandler)jpfContext.getBean(alias);
                this.specHandler.setAlias(alias);
            }
            Extension.Parameter param = extension.getParameter("mappingResource");
            if (param != null && StringUtils.isNotEmpty((String)(mappingResource = param.valueAsString()))) {
                URL url = classLoader.getResource(mappingResource);
                this.specHandler.setMappingResourceUrl(url);
                this.identifierMappingResourceMap.put(alias, url);
            }
            if ((param = extension.getParameter("specSpecificTTVXpathsFileName")) != null && StringUtils.isNotEmpty((String)(specSpecificTTVXpathsFileName = param.valueAsString()))) {
                InputStream specSpecificTTVXpathsFileNameStream = classLoader.getResourceAsStream(specSpecificTTVXpathsFileName);
                this.specHandler.setSpecSpecificTTVXpathsStream(specSpecificTTVXpathsFileNameStream);
            }
            ITranslator toTranslator = null;
            param = extension.getParameter("toTTV");
            if (param != null) {
                String toTTVXslPath = param.valueAsString();
                toTranslator = this.createToTranslator(extension, classLoader, toTTVXslPath);
            }
            this.specHandler.setToTTV(toTranslator);
            ITranslator fromTranslator = null;
            param = extension.getParameter("fromTTV");
            if (param != null) {
                String fromTTVXslPath = param.valueAsString();
                fromTranslator = this.createFromTranslator(extension, classLoader, fromTTVXslPath);
            }
            this.specHandler.setFromTTV(fromTranslator);
            param = extension.getParameter("schematronValidator");
            if (param != null && StringUtils.isNotEmpty((String)(validatorFilePath = param.valueAsString()))) {
                InputStream validatorStream = classLoader.getResourceAsStream(validatorFilePath);
                IValidator validator = this.createValidator(extension, classLoader, alias, validatorStream);
                HashMap<String, IValidator> validatorMap = new HashMap<String, IValidator>();
                validatorMap.put(alias + "Validator", validator);
                this.specHandler.setRuleValidators(validatorMap);
            }
            RuleManagerBase ruleManager = this.createRuleManager(extension, classLoader);
            ruleManager.setSpec(alias);
            ruleManager.setRuleManagerDAO(this.ruleManagerDAO);
            param = extension.getParameter("defaultRuleSet");
            if (param != null && StringUtils.isNotEmpty((String)(defaultRuleSetFilePath = param.valueAsString()))) {
                InputStream ruleSetStream = classLoader.getResourceAsStream(defaultRuleSetFilePath);
                Map<String, Boolean> defaultRuleSetMap = MappingFileParser.readFieldMappingWithBooleanValue(ruleSetStream);
                ruleManager.setDefaultRuleSet(defaultRuleSetMap);
            }
            this.specHandler.setRuleManager(ruleManager);
            this.specHandlerMap.put(alias, this.specHandler);
        }
        this.context.getBean("specHandlerFactory");
        SpecHandlerFactory.getHandlers().putAll(this.specHandlerMap);
        logger.info((Object)"Finished building Specifications");
    }

    private ITranslator createToTranslator(Extension extension, PluginClassLoader classLoader, String xslPath) throws RuntimeException {
        ITranslator toTranslator;
        Class<?> toTranslatorClass = this.loadClass(extension, classLoader, "toTtvTranslator");
        try {
            toTranslator = toTranslatorClass.getCanonicalName().equals("com.tandbergtv.metadatamanager.specimpl.XslTranslator") ? (ITranslator)toTranslatorClass.getConstructor(ClassLoader.class, String.class).newInstance(classLoader, xslPath) : (ITranslator)toTranslatorClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create instance of " + toTranslatorClass.getClass().getName(), e);
        }
        return toTranslator;
    }

    private ITranslator createFromTranslator(Extension extension, PluginClassLoader classLoader, String xslPath) throws RuntimeException {
        ITranslator fromTranslator;
        Class<?> fromTranslatorClass = this.loadClass(extension, classLoader, "fromTtvTranslator");
        try {
            fromTranslator = fromTranslatorClass.getCanonicalName().equals("com.tandbergtv.metadatamanager.specimpl.XslTranslator") ? (ITranslator)fromTranslatorClass.getConstructor(ClassLoader.class, String.class).newInstance(classLoader, xslPath) : (ITranslator)fromTranslatorClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create instance of " + fromTranslatorClass.getClass().getName(), e);
        }
        return fromTranslator;
    }

    private RuleManagerBase createRuleManager(Extension extension, PluginClassLoader classLoader) throws RuntimeException {
        RuleManagerBase ruleManager;
        Class<?> ruleManagerClass = this.loadClass(extension, classLoader, "ruleManager");
        try {
            ruleManager = (RuleManagerBase)ruleManagerClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create instance of " + ruleManagerClass.getClass().getName(), e);
        }
        return ruleManager;
    }

    private IValidator createValidator(Extension extension, PluginClassLoader classLoader, String alias, InputStream validatorStream) throws RuntimeException {
        IValidator validator;
        Class<?> validatorClass = this.loadClass(extension, classLoader, "validator");
        try {
            validator = (IValidator)validatorClass.getConstructor(String.class, InputStream.class, ClassLoader.class).newInstance(alias + "Validator", validatorStream, classLoader);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create instance of " + validatorClass.getClass().getName(), e);
        }
        return validator;
    }

    private Class<?> loadClass(Extension extension, PluginClassLoader classLoader, String paramName) throws RuntimeException {
        Class clazz;
        String classNameStr;
        Extension.Parameter className = extension.getParameter(paramName);
        String string = classNameStr = className != null ? className.valueAsString() : null;
        if (classNameStr == null || classNameStr.trim().length() == 0) {
            throw new RuntimeException("CLass not configured -  " + paramName + "Make sure to set the class in the plugin ");
        }
        try {
            clazz = classLoader.loadClass(classNameStr);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load class " + classNameStr, e);
        }
        return clazz;
    }
}

