/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.model;

public class CustomField {
    private String xpath;
    String name;
    String value;
    private int customFieldIndex = -1;
    private int ttvXPathCustomFieldIndex = -1;
    public static final String CUSTOMFIELD = "CustomField";
    public static final String ATTRIBUTE_NAME = "@name";
    public static final String ATTRIBUTE_VALUE = "@value";
    public static final String TNS_CUSTOMFIELDS = "/CustomFields";
    public static final String XPATH_DELIMITER = "/";
    public static final String CUSTOM_FIELD_XPATH_DISTINGUISHER = "CustomField{";
    public static final String NAME = "name";

    public CustomField(String xpath, String name, String value) {
        this.setXpath(xpath);
        this.name = name;
        this.value = value;
    }

    public CustomField(String xpath) {
        this.setXpath(xpath);
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
        this.customFieldIndex = this.readCustomFieldIndex();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getCustomFieldIndex() {
        return this.customFieldIndex;
    }

    public int getTtvXPathCustomFieldIndex() {
        return this.ttvXPathCustomFieldIndex;
    }

    public void setTtvXPathCustomFieldIndex(int ttvXPathCustomFieldIndex) {
        this.ttvXPathCustomFieldIndex = ttvXPathCustomFieldIndex;
    }

    public String constructTTVString() {
        int lastIndexPosition = this.xpath.lastIndexOf(123);
        String xpathBeforeLastIndex = this.xpath.substring(0, lastIndexPosition);
        String xpathLastIndex = "{" + this.getTtvXPathCustomFieldIndex() + "}";
        StringBuilder format = new StringBuilder();
        format.append(xpathBeforeLastIndex).append("[@name=%s]").append(xpathLastIndex).append(XPATH_DELIMITER).append("@value==%s");
        return String.format(format.toString(), this.getName(), this.getValue());
    }

    private int readCustomFieldIndex() {
        int startIndex = this.getCustomFieldIndexStart();
        int endIndex = this.getCustomFieldIndexEnd(startIndex);
        try {
            String subXpath = this.xpath.substring(startIndex, endIndex);
            return Integer.parseInt(subXpath);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The index for the custom field element is not a valid number, error: " + e.getLocalizedMessage());
        }
    }

    private int getCustomFieldIndexStart() {
        int startIndex = this.xpath.indexOf(CUSTOM_FIELD_XPATH_DISTINGUISHER);
        if (startIndex < 0) {
            throw new IllegalArgumentException("Failed to find start of index of custom field.");
        }
        return startIndex + CUSTOM_FIELD_XPATH_DISTINGUISHER.length();
    }

    private int getCustomFieldIndexEnd(int startIndex) {
        int endIndex = this.xpath.indexOf(125, startIndex);
        if (endIndex < 0) {
            throw new IllegalArgumentException("Failed to find end of index of the custom field.");
        }
        return endIndex;
    }

    public String toString() {
        return super.toString() + "(" + this.xpath + "," + this.name + "," + this.value + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.xpath == null ? 0 : this.xpath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomField other = (CustomField)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.xpath == null ? other.xpath != null : !this.xpath.equals(other.xpath));
    }
}

