/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.model;

import com.tandbergtv.metadatamanager.model.ChangeListener;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldBase;
import java.util.ArrayList;
import java.util.List;

public class TrackableArrayList
extends ArrayList<Field> {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean remove(Object o) {
        boolean result = super.remove(o);
        if (result && o instanceof FieldBase) {
            Field field = (Field)o;
            this.logChange(field);
        }
        return result;
    }

    @Override
    public Field remove(int index) {
        Field field = (Field)super.remove(index);
        this.logChange(field);
        return field;
    }

    private void logChange(Field field) {
        if (field == null || field.getRoot() == null) {
            return;
        }
        List<ChangeListener> listeners = field.getRoot().getRegisteredListeners();
        if (!listeners.isEmpty()) {
            for (ChangeListener listener : listeners) {
                listener.handleChange(field.getTtvXPath(), field.getParentAsset().getPath(), field.getValue(), "");
            }
        }
    }
}

