/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.oracle;

import com.tandbergtv.metadatamanager.MetadataManagerDAOImpl;
import com.tandbergtv.metadatamanager.search.MDMTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.hibernate.jdbc.Work;

public class DeleteMetadata
implements Work {
    private static final String SQL_COMMON_1 = "]' PASSING object_value AS \"p\")";
    private static final Logger logger = Logger.getLogger(MetadataManagerDAOImpl.class);
    protected long documentId;
    protected boolean isOriginal;

    public DeleteMetadata(boolean isOriginal, long documentId) {
        this.documentId = documentId;
        this.isOriginal = isOriginal;
    }

    protected String getInsertSql(long documentId) {
        StringBuilder s = new StringBuilder("INSERT into ");
        s.append(MDMTable.REVISION.getTableName());
        s.append(" (object_value)");
        s.append(" select object_value from ");
        if (this.isOriginal) {
            s.append(MDMTable.MASTER.getTableName());
        } else {
            s.append(MDMTable.COPY.getTableName());
        }
        s.append(" mdm");
        s.append(" WHERE XMLExists('$p/ECMFSpec[@documentId=");
        s.append(documentId);
        s.append("]' PASSING mdm.object_value AS \"p\")");
        return s.toString();
    }

    protected String getDelecteSql(long documentId) {
        StringBuilder s = new StringBuilder("DELETE from ");
        if (this.isOriginal) {
            s.append(MDMTable.MASTER.getTableName());
        } else {
            s.append(MDMTable.COPY.getTableName());
        }
        s.append(" WHERE XMLExists('$p/ECMFSpec[@documentId=");
        s.append(documentId);
        s.append(SQL_COMMON_1);
        return s.toString();
    }

    public void execute(Connection con) throws SQLException {
        String insSelSql = this.getInsertSql(this.documentId);
        logger.debug((Object)insSelSql);
        try (PreparedStatement st = con.prepareStatement(insSelSql);){
            st.execute();
        }
        String delSql = this.getDelecteSql(this.documentId);
        logger.debug((Object)delSql);
        try (PreparedStatement st = con.prepareStatement(delSql);){
            st.execute();
        }
    }
}

